/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.books;

import com.google.gdata.client.AuthTokenFactory;
import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Service;
import com.google.gdata.data.batch.BatchUtils;
import com.google.gdata.data.books.CollectionFeed;
import com.google.gdata.data.books.VolumeFeed;
import com.google.gdata.util.Version;
import com.google.gdata.util.VersionRegistry;

public class BooksService
extends GoogleService {
    public static final String BOOKS_SERVICE = "print";
    public static final String BOOKS_SERVICE_VERSION = "GBooks-Java/" + BooksService.class.getPackage().getImplementationVersion();
    public static final Version DEFAULT_VERSION = Service.initServiceVersion(BooksService.class, Versions.V1);

    public BooksService(String applicationName) {
        super(BOOKS_SERVICE, applicationName);
        this.declareExtensions();
    }

    public BooksService(String applicationName, Service.GDataRequestFactory requestFactory, AuthTokenFactory authTokenFactory) {
        super(applicationName, requestFactory, authTokenFactory);
        this.declareExtensions();
    }

    public BooksService(String applicationName, String protocol, String domainName) {
        super(BOOKS_SERVICE, applicationName, protocol, domainName);
        this.declareExtensions();
    }

    @Override
    public String getServiceVersion() {
        return BOOKS_SERVICE_VERSION + " " + super.getServiceVersion();
    }

    public static Version getVersion() {
        return VersionRegistry.get().getVersion(BooksService.class);
    }

    private void declareExtensions() {
        new CollectionFeed().declareExtensions(this.extProfile);
        new VolumeFeed().declareExtensions(this.extProfile);
        BatchUtils.declareExtensions(this.extProfile);
    }

    public static final class Versions {
        public static final Version V1 = new Version(BooksService.class, "1.0", Service.Versions.V1);
        public static final Version V2 = new Version(BooksService.class, "2.0", Service.Versions.V2);

        private Versions() {
        }
    }
}

