/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.calendar;

import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Link;
import com.google.gdata.data.calendar.AnyoneCanAddSelfProperty;
import com.google.gdata.data.calendar.EventWho;
import com.google.gdata.data.calendar.GuestsCanInviteOthersProperty;
import com.google.gdata.data.calendar.GuestsCanModifyProperty;
import com.google.gdata.data.calendar.GuestsCanSeeGuestsProperty;
import com.google.gdata.data.calendar.IcalUIDProperty;
import com.google.gdata.data.calendar.PrivateCopyProperty;
import com.google.gdata.data.calendar.QuickAddProperty;
import com.google.gdata.data.calendar.ResourceProperty;
import com.google.gdata.data.calendar.SendEventNotificationsProperty;
import com.google.gdata.data.calendar.SequenceNumberProperty;
import com.google.gdata.data.calendar.SyncEventProperty;
import com.google.gdata.data.calendar.WebContent;
import com.google.gdata.data.extensions.BaseEventEntry;
import com.google.gdata.data.extensions.ExtendedProperty;
import java.util.List;

public class CalendarEventEntry
extends BaseEventEntry<CalendarEventEntry> {
    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        super.declareExtensions(extProfile);
        extProfile.declare(CalendarEventEntry.class, QuickAddProperty.getDefaultDescription());
        extProfile.declare(CalendarEventEntry.class, ExtendedProperty.getDefaultDescription());
        extProfile.declare(CalendarEventEntry.class, SendEventNotificationsProperty.getDefaultDescription());
        extProfile.declare(CalendarEventEntry.class, IcalUIDProperty.getDefaultDescription());
        extProfile.declare(CalendarEventEntry.class, SequenceNumberProperty.getDefaultDescription());
        extProfile.declare(CalendarEventEntry.class, SyncEventProperty.getDefaultDescription());
        extProfile.declare(CalendarEventEntry.class, PrivateCopyProperty.getDefaultDescription(false, false));
        extProfile.declare(CalendarEventEntry.class, EventWho.getDefaultDescription());
        extProfile.declare(EventWho.class, ResourceProperty.getDefaultDescription());
        extProfile.declare(Link.class, WebContent.getDefaultDescription());
        extProfile.declare(CalendarEventEntry.class, GuestsCanModifyProperty.getDefaultDescription(false, false));
        extProfile.declare(CalendarEventEntry.class, GuestsCanInviteOthersProperty.getDefaultDescription(false, false));
        extProfile.declare(CalendarEventEntry.class, GuestsCanSeeGuestsProperty.getDefaultDescription(false, false));
        extProfile.declare(CalendarEventEntry.class, AnyoneCanAddSelfProperty.getDefaultDescription(false, false));
    }

    public List<EventWho> getParticipants() {
        return this.getRepeatingExtension(EventWho.class);
    }

    public void addParticipant(EventWho participant) {
        this.getParticipants().add(participant);
    }

    public List<ExtendedProperty> getExtendedProperty() {
        return this.getRepeatingExtension(ExtendedProperty.class);
    }

    public void addExtendedProperty(ExtendedProperty prop) {
        this.getExtendedProperty().add(prop);
    }

    public boolean getQuickAdd() {
        QuickAddProperty quickAdd = this.getExtension(QuickAddProperty.class);
        return quickAdd != null && "true".equalsIgnoreCase(quickAdd.getValue());
    }

    public void setQuickAdd(boolean quickAdd) {
        this.setExtension(quickAdd ? QuickAddProperty.TRUE : QuickAddProperty.FALSE);
    }

    public boolean isSyncEvent() {
        SyncEventProperty syncEvent = this.getExtension(SyncEventProperty.class);
        return syncEvent != null && "true".equalsIgnoreCase(syncEvent.getValue());
    }

    public void setSyncEvent(boolean syncEvent) {
        this.setExtension(syncEvent ? SyncEventProperty.TRUE : SyncEventProperty.FALSE);
    }

    public boolean isPrivateCopy() {
        PrivateCopyProperty privateCopy = this.getExtension(PrivateCopyProperty.class);
        return privateCopy != null && privateCopy.getValue() != false;
    }

    public void setPrivateCopy(boolean privateCopy) {
        this.setExtension(privateCopy ? PrivateCopyProperty.TRUE : PrivateCopyProperty.FALSE);
    }

    public boolean getSendEventNotifications() {
        SendEventNotificationsProperty send = this.getExtension(SendEventNotificationsProperty.class);
        return send != null && Boolean.parseBoolean(send.getValue());
    }

    public void setSendEventNotifications(boolean send) {
        this.setExtension(send ? SendEventNotificationsProperty.TRUE : SendEventNotificationsProperty.FALSE);
    }

    public String getIcalUID() {
        IcalUIDProperty uid = this.getExtension(IcalUIDProperty.class);
        return uid == null ? null : uid.getValue();
    }

    public void setIcalUID(String uid) {
        if (uid == null) {
            this.removeExtension(IcalUIDProperty.class);
        } else {
            this.setExtension(new IcalUIDProperty(uid));
        }
    }

    public boolean hasSequence() {
        return this.hasExtension(SequenceNumberProperty.class);
    }

    public int getSequence() {
        SequenceNumberProperty seq = this.getExtension(SequenceNumberProperty.class);
        return seq == null ? 0 : Integer.parseInt(seq.getValue());
    }

    public void setSequence(int sequence) {
        this.setExtension(new SequenceNumberProperty(String.valueOf(sequence)));
    }

    public Link getWebContentLink() {
        return this.getLink("http://schemas.google.com/gCal/2005/webContent", null);
    }

    public WebContent getWebContent() {
        Link webContentLink = this.getWebContentLink();
        if (webContentLink == null) {
            return null;
        }
        return webContentLink.getExtension(WebContent.class);
    }

    public void setWebContent(WebContent wc) {
        Link oldWebContentLink = this.getWebContentLink();
        if (wc == null) {
            if (oldWebContentLink != null) {
                this.getLinks().remove(oldWebContentLink);
            }
        } else if (oldWebContentLink == null) {
            this.getLinks().add(wc.getLink());
        } else if (oldWebContentLink != wc.getLink()) {
            this.getLinks().remove(oldWebContentLink);
            this.getLinks().add(wc.getLink());
        }
    }

    public void setGuestsCanModify(boolean guestsCanModify) {
        this.setExtension(guestsCanModify ? GuestsCanModifyProperty.TRUE : GuestsCanModifyProperty.FALSE);
    }

    public boolean isGuestsCanModify() {
        GuestsCanModifyProperty guestsCanModify = this.getExtension(GuestsCanModifyProperty.class);
        return guestsCanModify != null && guestsCanModify.getValue() != false;
    }

    public boolean hasGuestsCanModify() {
        return this.hasExtension(GuestsCanModifyProperty.class);
    }

    public void setGuestsCanInviteOthers(boolean guestsCanInviteOthers) {
        this.setExtension(guestsCanInviteOthers ? GuestsCanInviteOthersProperty.TRUE : GuestsCanInviteOthersProperty.FALSE);
    }

    public boolean isGuestsCanInviteOthers() {
        GuestsCanInviteOthersProperty guestsCanInviteOthers = this.getExtension(GuestsCanInviteOthersProperty.class);
        return guestsCanInviteOthers != null && guestsCanInviteOthers.getValue() != false;
    }

    public boolean hasGuestsCanInviteOthers() {
        return this.hasExtension(GuestsCanInviteOthersProperty.class);
    }

    public void setGuestsCanSeeGuests(boolean guestsCanSeeGuests) {
        this.setExtension(guestsCanSeeGuests ? GuestsCanSeeGuestsProperty.TRUE : GuestsCanSeeGuestsProperty.FALSE);
    }

    public boolean isGuestsCanSeeGuests() {
        GuestsCanSeeGuestsProperty guestsCanSeeGuests = this.getExtension(GuestsCanSeeGuestsProperty.class);
        return guestsCanSeeGuests != null && guestsCanSeeGuests.getValue() != false;
    }

    public boolean hasGuestsCanSeeGuests() {
        return this.hasExtension(GuestsCanSeeGuestsProperty.class);
    }

    public void setAnyoneCanAddSelf(boolean anyoneCanAddSelf) {
        this.setExtension(anyoneCanAddSelf ? AnyoneCanAddSelfProperty.TRUE : AnyoneCanAddSelfProperty.FALSE);
    }

    public boolean isAnyoneCanAddSelf() {
        AnyoneCanAddSelfProperty anyoneCanAddSelf = this.getExtension(AnyoneCanAddSelfProperty.class);
        return anyoneCanAddSelf != null && anyoneCanAddSelf.getValue() != false;
    }

    public boolean hasAnyoneCanAddSelf() {
        return this.hasExtension(AnyoneCanAddSelfProperty.class);
    }
}

