/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.photos.impl;

import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.geo.Box;
import com.google.gdata.data.geo.Point;
import com.google.gdata.data.geo.impl.BoxDataImpl;
import com.google.gdata.data.geo.impl.PointDataImpl;
import com.google.gdata.data.media.mediarss.MediaCategory;
import com.google.gdata.data.media.mediarss.MediaContent;
import com.google.gdata.data.media.mediarss.MediaCredit;
import com.google.gdata.data.media.mediarss.MediaGroup;
import com.google.gdata.data.media.mediarss.MediaKeywords;
import com.google.gdata.data.media.mediarss.MediaThumbnail;
import com.google.gdata.data.photos.AlbumData;
import com.google.gdata.data.photos.GphotoAccess;
import com.google.gdata.data.photos.GphotoBytesUsed;
import com.google.gdata.data.photos.GphotoCommentCount;
import com.google.gdata.data.photos.GphotoCommentsEnabled;
import com.google.gdata.data.photos.GphotoLocation;
import com.google.gdata.data.photos.GphotoName;
import com.google.gdata.data.photos.GphotoNickname;
import com.google.gdata.data.photos.GphotoPhotosLeft;
import com.google.gdata.data.photos.GphotoPhotosUsed;
import com.google.gdata.data.photos.GphotoTimestamp;
import com.google.gdata.data.photos.GphotoUsername;
import com.google.gdata.data.photos.impl.GphotoDataImpl;
import com.google.gdata.data.photos.impl.MediaDataImpl;
import com.google.gdata.data.photos.pheed.PheedImageUrl;
import com.google.gdata.data.photos.pheed.PheedThumbnail;
import java.util.Date;
import java.util.List;

public class AlbumDataImpl
extends GphotoDataImpl
implements AlbumData {
    private final PointDataImpl pointData;
    private final BoxDataImpl boundingBoxData;
    private final MediaDataImpl mediaData;

    public AlbumDataImpl(ExtensionPoint extensionPoint) {
        super(extensionPoint);
        this.pointData = new PointDataImpl(extensionPoint);
        this.boundingBoxData = new BoxDataImpl(extensionPoint);
        this.mediaData = new MediaDataImpl(extensionPoint);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        super.declareExtensions(extProfile);
        this.declare(extProfile, PheedThumbnail.getDefaultDescription());
        this.declare(extProfile, PheedImageUrl.getDefaultDescription());
        this.declare(extProfile, GphotoName.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoLocation.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoTimestamp.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoAccess.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoPhotosUsed.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoPhotosLeft.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoBytesUsed.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoUsername.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoNickname.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoCommentsEnabled.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoCommentCount.getDefaultDescription(false, false));
        this.pointData.declareExtensions(extProfile);
        this.boundingBoxData.declareExtensions(extProfile);
        this.mediaData.declareExtensions(extProfile);
    }

    @Deprecated
    public String getThumbnail() {
        return this.getSimpleValue(PheedThumbnail.class);
    }

    @Deprecated
    public void setThumbnail(String thumbUrl) {
        if (thumbUrl != null) {
            this.setExtension(new PheedThumbnail(thumbUrl));
        } else {
            this.removeExtension(PheedThumbnail.class);
        }
    }

    @Deprecated
    public String getImageUrl() {
        return this.getSimpleValue(PheedImageUrl.class);
    }

    @Deprecated
    public void setImageUrl(String imageUrl) {
        if (imageUrl != null) {
            this.setExtension(new PheedImageUrl(imageUrl));
        } else {
            this.removeExtension(PheedImageUrl.class);
        }
    }

    @Override
    public String getName() {
        return this.getSimpleValue(GphotoName.class);
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            this.setExtension(new GphotoName(name));
        } else {
            this.removeExtension(GphotoName.class);
        }
    }

    @Override
    public String getLocation() {
        return this.getSimpleValue(GphotoLocation.class);
    }

    @Override
    public void setLocation(String location) {
        if (location != null) {
            this.setExtension(new GphotoLocation(location));
        } else {
            this.removeExtension(GphotoLocation.class);
        }
    }

    @Override
    public Date getDate() {
        GphotoTimestamp ext = this.getExtension(GphotoTimestamp.class);
        return ext == null ? null : new Date(ext.getValue());
    }

    @Override
    public void setDate(Date date) {
        if (date != null) {
            this.setExtension(new GphotoTimestamp(date));
        } else {
            this.removeExtension(GphotoTimestamp.class);
        }
    }

    @Override
    public String getAccess() {
        GphotoAccess access = this.getExtension(GphotoAccess.class);
        return access == null ? null : access.getValue().toLowerCase();
    }

    @Override
    public void setAccess(String access) {
        if (access != null) {
            this.setExtension(new GphotoAccess(access));
        } else {
            this.removeExtension(GphotoAccess.class);
        }
    }

    @Override
    public Integer getPhotosUsed() {
        GphotoPhotosUsed photosUsed = this.getExtension(GphotoPhotosUsed.class);
        return photosUsed == null ? null : photosUsed.getValue();
    }

    @Override
    public void setPhotosUsed(Integer photosUsed) {
        if (photosUsed != null) {
            this.setExtension(new GphotoPhotosUsed(photosUsed));
        } else {
            this.removeExtension(GphotoPhotosUsed.class);
        }
    }

    @Override
    public Integer getPhotosLeft() {
        GphotoPhotosLeft left = this.getExtension(GphotoPhotosLeft.class);
        return left == null ? null : left.getValue();
    }

    @Override
    public void setPhotosLeft(Integer photosLeft) {
        if (photosLeft != null) {
            this.setExtension(new GphotoPhotosLeft(photosLeft));
        } else {
            this.removeExtension(GphotoPhotosLeft.class);
        }
    }

    @Override
    public Long getBytesUsed() {
        GphotoBytesUsed used = this.getExtension(GphotoBytesUsed.class);
        return used == null ? null : used.getValue();
    }

    @Override
    public void setBytesUsed(Long bytesUsed) {
        if (bytesUsed != null) {
            this.setExtension(new GphotoBytesUsed(bytesUsed));
        } else {
            this.removeExtension(GphotoBytesUsed.class);
        }
    }

    @Override
    public String getUsername() {
        return this.getSimpleValue(GphotoUsername.class);
    }

    @Override
    public void setUsername(String username) {
        if (username != null) {
            this.setExtension(new GphotoUsername(username));
        } else {
            this.removeExtension(GphotoUsername.class);
        }
    }

    @Override
    public String getNickname() {
        return this.getSimpleValue(GphotoNickname.class);
    }

    @Override
    public void setNickname(String nickname) {
        if (nickname != null) {
            this.setExtension(new GphotoNickname(nickname));
        } else {
            this.removeExtension(GphotoNickname.class);
        }
    }

    @Override
    public Boolean getCommentsEnabled() {
        GphotoCommentsEnabled left = this.getExtension(GphotoCommentsEnabled.class);
        return left == null ? null : left.getValue();
    }

    @Override
    public void setCommentsEnabled(Boolean commentsEnabled) {
        if (commentsEnabled != null) {
            this.setExtension(new GphotoCommentsEnabled(commentsEnabled));
        } else {
            this.removeExtension(GphotoCommentsEnabled.class);
        }
    }

    @Override
    public Integer getCommentCount() {
        GphotoCommentCount left = this.getExtension(GphotoCommentCount.class);
        return left == null ? null : left.getValue();
    }

    @Override
    public void setCommentCount(Integer commentCount) {
        if (commentCount != null) {
            this.setExtension(new GphotoCommentCount(commentCount));
        } else {
            this.removeExtension(GphotoCommentCount.class);
        }
    }

    @Override
    public void setGeoLocation(Double lat, Double lon) {
        this.pointData.setGeoLocation(lat, lon);
    }

    @Override
    public void setGeoLocation(Point point) {
        this.pointData.setGeoLocation(point);
    }

    @Override
    public Point getGeoLocation() {
        return this.pointData.getGeoLocation();
    }

    @Override
    public Box getGeoBoundingBox() {
        return this.boundingBoxData.getGeoBoundingBox();
    }

    @Override
    public void setGeoBoundingBox(Point lowerLeft, Point upperRight) {
        this.boundingBoxData.setGeoBoundingBox(lowerLeft, upperRight);
    }

    @Override
    public void setGeoBoundingBox(Box boundingBox) {
        this.boundingBoxData.setGeoBoundingBox(boundingBox);
    }

    @Override
    public void clearPoint() {
        this.pointData.clearPoint();
    }

    @Override
    public void clearGeoBoundingBox() {
        this.boundingBoxData.clearGeoBoundingBox();
    }

    @Override
    public MediaGroup getMediaGroup() {
        return this.mediaData.getMediaGroup();
    }

    @Override
    public List<MediaContent> getMediaContents() {
        return this.mediaData.getMediaContents();
    }

    @Override
    public List<MediaCategory> getMediaCategories() {
        return this.mediaData.getMediaCategories();
    }

    @Override
    public List<MediaCredit> getMediaCredits() {
        return this.mediaData.getMediaCredits();
    }

    @Override
    public List<MediaThumbnail> getMediaThumbnails() {
        return this.mediaData.getMediaThumbnails();
    }

    @Override
    public MediaKeywords getMediaKeywords() {
        return this.mediaData.getMediaKeywords();
    }

    @Override
    public void setKeywords(MediaKeywords keywords) {
        this.mediaData.setKeywords(keywords);
    }
}

