/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.gradle;

import com.mulesoft.gradle.EC2PluginExtension;
import com.mulesoft.gradle.common.EnvironmentConstants;
import com.netflix.gradle.plugins.daemon.TemplateHelper;
import java.io.File;
import java.util.Map;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

class UserDataTemplateTask
extends ConventionTask {
    private Map<String, String> context;
    private File destDir;

    @Input
    public Map<String, String> getContext() {
        return this.context;
    }

    @Input
    public File getDestDir() {
        return this.destDir;
    }

    public void setDestDir(File dir) {
        this.destDir = dir;
    }

    public void setContext(Map<String, String> map) {
        this.context = map;
    }

    @TaskAction
    public void template() {
        EC2PluginExtension extension = (EC2PluginExtension)this.getProject().getExtensions().getByType(EC2PluginExtension.class);
        if (extension.enabled) {
            this.context.put(EnvironmentConstants.EXTRA_LINES.value(), extension.userDataLines);
            this.context.put(EnvironmentConstants.ROLE_NAME.value(), "".equals(extension.userDataRole) ? this.getProject().getName() : extension.userDataRole);
            TemplateHelper templateHelper = new TemplateHelper(this.destDir, "/com/mulesoft/gradle/plugins/ec2init");
            templateHelper.generateFile("ec2-init.sh", this.context);
        }
    }

    @OutputFile
    File getTemplatesOutout() {
        return new File(this.destDir, "ec2-init.sh");
    }
}

