/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.gradle;

import com.mulesoft.BaseServicePlugin;
import com.mulesoft.gradle.EC2Plugin;
import com.mulesoft.gradle.NodeServiceExtension;
import com.mulesoft.gradle.UpstartPlugin;
import com.mulesoft.gradle.common.EnvironmentConstants;
import com.netflix.gradle.plugins.rpm.Rpm;
import com.netflix.gradle.plugins.rpm.RpmPlugin;
import org.gradle.api.Project;
import org.redline_rpm.header.Os;

public class NodeServicePlugin
extends BaseServicePlugin {
    @Override
    public void apply(Project project) {
        super.apply(project);
        project.getPlugins().apply(RpmPlugin.class);
        project.getExtensions().create("nodeService", NodeServiceExtension.class, new Object[0]);
        Rpm rpm = (Rpm)project.getTasks().create("buildRpm", Rpm.class);
        project.getPlugins().add((Object)new EC2Plugin());
        project.afterEvaluate(p -> {
            NodeServiceExtension nodeService = (NodeServiceExtension)p.getExtensions().getByType(NodeServiceExtension.class);
            String environmentPath = EnvironmentConstants.ENV_FILE_PATH.value() + p.getName() + "/";
            String command = "chdir /usr/" + project.getName() + "\nscript\ntouch " + environmentPath + p.getName() + ".sh\nexec bash -c 'source " + environmentPath + p.getName() + ".sh && source ~/.nvm/nvm.sh && nvm use v" + nodeService.nodeVersion + " && node " + nodeService.entryPoint + " >> " + EnvironmentConstants.LOG_FILE_PATH.value() + project.getName() + "/" + project.getName() + ".log 2>&1 '\nend script";
            UpstartPlugin upstartPlugin = new UpstartPlugin(command, nodeService.runAsUser);
            project.getPlugins().add((Object)upstartPlugin);
            if (p.getPlugins().hasPlugin("com.moowork.node")) {
                rpm.dependsOn(new Object[]{project.getTasks().getByName("npmInstall")});
            }
            rpm.requires("man");
            rpm.requires("upstart");
            rpm.requires("which");
            rpm.setArch((Object)"x86_64");
            rpm.setOs(Os.LINUX);
            String runAsUser = nodeService.runAsUser != null ? nodeService.runAsUser : EnvironmentConstants.ROOT_USER.value();
            rpm.setUser(runAsUser);
            String branchName = System.getenv(EnvironmentConstants.BRANCH_NAME.value());
            rpm.setPackageName(p.getName() + (branchName != null ? "-" + branchName : ""));
            rpm.into((Object)(EnvironmentConstants.USR_PATH.value() + p.getName()), copySpec -> copySpec.from(new Object[]{nodeService.entryPoint, "./package.json"}));
            if (nodeService.customSources != null) {
                String[] customSources;
                for (String extraSource : customSources = nodeService.customSources.split(",")) {
                    rpm.into((Object)(EnvironmentConstants.USR_PATH.value() + p.getName() + "/" + extraSource), copySpec -> copySpec.from(new Object[]{extraSource}).exclude(new String[]{"**/*.ts"}));
                }
            } else {
                rpm.into((Object)(EnvironmentConstants.USR_PATH.value() + p.getName() + "/src"), copySpec -> copySpec.from(new Object[]{"src"}).exclude(new String[]{"**/*.ts"}));
                rpm.into((Object)(EnvironmentConstants.USR_PATH.value() + p.getName() + "/config"), copySpec -> copySpec.from(new Object[]{"config"}).exclude(new String[]{"**/*.ts"}));
                rpm.into((Object)(EnvironmentConstants.USR_PATH.value() + p.getName() + "/node_modules"), copySpec -> copySpec.from(new Object[]{"node_modules"}).exclude(new String[]{"**/*.ts"}));
            }
            if (nodeService.extraSources != null) {
                String[] extraSources;
                for (String extraSource : extraSources = nodeService.extraSources.split(",")) {
                    rpm.into((Object)(EnvironmentConstants.USR_PATH.value() + p.getName() + "/" + extraSource), copySpec -> copySpec.from(new Object[]{extraSource}).exclude(new String[]{"**/*.ts"}));
                }
            }
            rpm.preInstall(this.preInstall(p.getName(), nodeService));
            rpm.postInstall(this.postInstall(nodeService.nodeVersion));
        });
    }

    private String preInstall(String projectName, NodeServiceExtension nodeService) {
        String logFilePath = EnvironmentConstants.LOG_FILE_PATH.value() + projectName;
        String envFilePath = EnvironmentConstants.ENV_FILE_PATH.value() + projectName;
        StringBuilder commands = new StringBuilder("mkdir -p ").append(logFilePath).append("/\n");
        commands.append("mkdir -p ").append(envFilePath).append("/\n");
        if (nodeService.runAsUser != null) {
            commands.append("chown -R ").append(nodeService.runAsUser).append(logFilePath);
            commands.append("chown -R ").append(nodeService.runAsUser).append(envFilePath);
        }
        return commands.toString();
    }

    private String postInstall(String nodeVersion) {
        return "touch ~/.bash_profile\ncurl https://raw.githubusercontent.com/creationix/nvm/v0.13.1/install.sh | bash\nsource ~/.bash_profile\nnvm install v" + nodeVersion;
    }
}

