/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.gradle;

import com.mulesoft.gradle.SonarPluginExtension;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class SonarPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        SonarPluginExtension sonar = (SonarPluginExtension)project.getExtensions().create("sonar", SonarPluginExtension.class, new Object[]{project.getName()});
        project.getPlugins().apply("org.sonarqube");
        project.afterEvaluate(project1 -> {
            System.getProperties().put("sonar.host.url", sonar.url != null ? sonar.url : "");
            System.getProperties().put("sonar.login", sonar.login != null ? sonar.login : "");
            System.getProperties().put("sonar.projectKey", "mulesoft." + project1.getName());
            System.getProperties().put("sonar.projectName", project1.getDescription() == null ? project1.getName() : project1.getDescription());
            System.getProperties().put("sonar.projectVersion", project1.getVersion());
            System.getProperties().put("sonar.sourceEncoding", "UTF-8");
            System.getProperties().put("sonar.exclusions", "src/test/resources/**");
            System.getProperties().put("sonar.tests", "src/test");
            System.getProperties().put("sonar.scoverage.reportPath", project1.getBuildDir() + "/reports/scoverage/scoverage.xml");
            System.getProperties().put("sonar.github.repository", sonar.githubRepository);
        });
    }
}

