/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.gradle;

import com.netflix.gradle.plugins.daemon.DaemonExtension;
import com.netflix.gradle.plugins.packaging.ProjectPackagingExtension;
import java.util.ArrayList;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.redline_rpm.header.Os;

public class JVMServicePlugin
implements Plugin<Project> {
    private static final String PRE_INSTALL = "cd /usr/src\nwget http://cr.yp.to/daemontools/daemontools-0.76.tar.gz\ntar -xzvf daemontools-0.76.tar.gz\necho gcc -O2 -include /usr/include/errno.h > admin/daemontools-0.76/src/conf-cc\ncd admin/daemontools-0.76/\npackage/install\necho \"start on runlevel [12345]\" > /etc/init/svscan.conf\necho \"respawn\" >> /etc/init/svscan.conf\necho \"exec /command/svscanboot\" >> /etc/init/svscan.conf\ninitctl reload-configuration\ninitctl start svscan\nln -s /service /etc/service\nupdate-alternatives --set java /usr/lib/jvm/jre-1.8.0-openjdk.x86_64/bin/java\nln -s /usr/local/bin/svc /usr/bin/svc";

    public void apply(Project project) {
        project.getPlugins().apply("nebula.ospackage-application-daemon");
        project.afterEvaluate(p -> {
            ProjectPackagingExtension ext = (ProjectPackagingExtension)p.getExtensions().findByType(ProjectPackagingExtension.class);
            ext.requires("initscripts");
            ext.requires("gcc-c++");
            ext.requires("wget");
            ext.requires("java-1.8.0-openjdk");
            ext.setArch((Object)"x86_64");
            ext.setOs(Os.LINUX);
            ext.setUser("root");
            String buildNumber = System.getenv("BUILD_NUMBER");
            String branchName = System.getenv("BRANCH_NAME");
            ext.setPackageName(p.getName() + (branchName != null ? "_" + branchName : ""));
            ext.preInstall(PRE_INSTALL);
            ArrayList<String> jvmArgs = new ArrayList<String>();
            jvmArgs.add("-Djava.net.preferIPv4Stack=true");
            p.getConvention().getExtensionsAsDynamicObject().setProperty("applicationDefaultJvmArgs", jvmArgs);
            DaemonExtension daemonExt = (DaemonExtension)p.getExtensions().findByType(DaemonExtension.class);
            daemonExt.getDaemons().all(daemonDefinition -> {
                daemonDefinition.setUser("nobody");
                daemonDefinition.setAutoStart(Boolean.valueOf(true));
            });
        });
    }
}

