/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.gradle;

import com.netflix.gradle.plugins.daemon.DaemonExtension;
import com.netflix.gradle.plugins.packaging.ProjectPackagingExtension;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.jvm.application.tasks.CreateStartScripts;
import org.gradle.tooling.BuildException;
import org.redline_rpm.header.Os;

public class JVMServicePlugin
implements Plugin<Project> {
    private static final String PRE_INSTALL = "cd /usr/src\nwget http://cr.yp.to/daemontools/daemontools-0.76.tar.gz\ntar -xzvf daemontools-0.76.tar.gz\necho gcc -O2 -include /usr/include/errno.h > admin/daemontools-0.76/src/conf-cc\ncd admin/daemontools-0.76/\npackage/install\necho \"start on runlevel [12345]\" > /etc/init/svscan.conf\necho \"respawn\" >> /etc/init/svscan.conf\necho \"exec /command/svscanboot\" >> /etc/init/svscan.conf\ninitctl reload-configuration\ninitctl start svscan\nln -s /service /etc/service\nupdate-alternatives --set java /usr/lib/jvm/jre-1.8.0-openjdk.x86_64/bin/java\nln -s /usr/local/bin/svc /usr/bin/svc";

    public void apply(Project project) {
        project.getPlugins().apply("nebula.ospackage-application-daemon");
        project.afterEvaluate(p -> {
            ProjectPackagingExtension ext = (ProjectPackagingExtension)p.getExtensions().findByType(ProjectPackagingExtension.class);
            ext.requires("initscripts");
            ext.requires("gcc-c++");
            ext.requires("make");
            ext.requires("wget");
            ext.requires("java-1.8.0-openjdk");
            ext.setArch((Object)"x86_64");
            ext.setOs(Os.LINUX);
            ext.setUser("root");
            ext.configurationFile("/etc/defaults/" + p.getName());
            String branchName = System.getenv("BRANCH_NAME");
            ext.setPackageName(p.getName() + (branchName != null ? "_" + branchName : ""));
            ext.preInstall(PRE_INSTALL);
            ArrayList<String> jvmArgs = new ArrayList<String>();
            jvmArgs.add("-Djava.net.preferIPv4Stack=true");
            p.getConvention().getExtensionsAsDynamicObject().setProperty("applicationDefaultJvmArgs", jvmArgs);
            DaemonExtension daemonExt = (DaemonExtension)p.getExtensions().findByType(DaemonExtension.class);
            daemonExt.getDaemons().all(daemonDefinition -> {
                daemonDefinition.setUser("root");
                daemonDefinition.setAutoStart(Boolean.valueOf(true));
            });
            CreateStartScripts startScripts = (CreateStartScripts)p.getTasks().findByName("startScripts");
            startScripts.doLast(task -> {
                List<String> lines = null;
                String extraLine = "##### Read config vars\n. /etc/default/" + p.getName() + "\n";
                try {
                    Path path = ((CreateStartScripts)task).getUnixScript().toPath();
                    lines = Files.readAllLines(path, StandardCharsets.UTF_8);
                    lines.add(lines.size() - 1, extraLine);
                    Files.write(path, lines, StandardCharsets.UTF_8, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new BuildException(e.getMessage(), (Throwable)e);
                }
            });
        });
    }
}

