/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.gradle;

import com.mulesoft.gradle.NodeServiceExtension;
import com.mulesoft.gradle.UpstartPlugin;
import com.netflix.gradle.plugins.rpm.Rpm;
import com.netflix.gradle.plugins.rpm.RpmPlugin;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.redline_rpm.header.Os;

public class NodeServicePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(RpmPlugin.class);
        project.getExtensions().create("nodeService", NodeServiceExtension.class, new Object[0]);
        project.afterEvaluate(p -> {
            NodeServiceExtension nodeService = (NodeServiceExtension)p.getExtensions().getByType(NodeServiceExtension.class);
            String command = "chdir /usr/" + project.getName() + "\nnvm use v" + nodeService.nodeVersion + "\nexec node " + nodeService.entryPoint;
            UpstartPlugin upstartPlugin = new UpstartPlugin(command);
            project.getPlugins().add((Object)upstartPlugin);
            Rpm rpm = (Rpm)project.getTasks().create("buildRpm", Rpm.class);
            if (p.getPlugins().hasPlugin("com.moowork.node")) {
                rpm.dependsOn(new Object[]{project.getTasks().getByName("npmInstall")});
            }
            rpm.requires("man");
            rpm.requires("upstart");
            rpm.requires("which");
            rpm.setArch((Object)"x86_64");
            rpm.setOs(Os.LINUX);
            rpm.setUser("root");
            String branchName = System.getenv("BRANCH_NAME");
            rpm.setPackageName(p.getName() + (branchName != null ? "_" + branchName : ""));
            rpm.into((Object)("/usr/" + p.getName()), copySpec -> copySpec.from(new Object[]{nodeService.entryPoint, "./package.json"}));
            rpm.into((Object)("/usr/" + p.getName() + "/src"), copySpec -> copySpec.from(new Object[]{"src"}).exclude(new String[]{"**/*.ts"}));
            rpm.into((Object)("/usr/" + p.getName() + "/config"), copySpec -> copySpec.from(new Object[]{"config"}).exclude(new String[]{"**/*.ts"}));
            rpm.into((Object)("/usr/" + p.getName() + "/node_modules"), copySpec -> copySpec.from(new Object[]{"node_modules"}).exclude(new String[]{"**/*.ts"}));
            rpm.postInstall(NodeServicePlugin.postInstall(nodeService.nodeVersion));
        });
    }

    private static String postInstall(String nodeVersion) {
        return "touch ~/.bash_profile\ncurl https://raw.githubusercontent.com/creationix/nvm/v0.13.1/install.sh | bash\nsource ~/.bash_profile\nnvm install v" + nodeVersion;
    }
}

