/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.gradle;

import com.mulesoft.gradle.SonarPluginExtension;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class SonarPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        SonarPluginExtension sonar = (SonarPluginExtension)project.getExtensions().create("sonar", SonarPluginExtension.class, new Object[]{project.getName()});
        project.getPlugins().apply("org.sonarqube");
        project.afterEvaluate(p -> {
            System.getProperties().put("sonar.host.url", sonar.url != null ? sonar.url : "");
            System.getProperties().put("sonar.login", sonar.login != null ? sonar.login : "");
            System.getProperties().put("sonar.projectKey", "mulesoft." + p.getName());
            System.getProperties().put("sonar.projectName", p.getDescription() == null ? p.getName() : p.getDescription());
            System.getProperties().put("sonar.projectVersion", p.getVersion());
            System.getProperties().put("sonar.sourceEncoding", "UTF-8");
            System.getProperties().put("sonar.exclusions", sonar.exclusions);
            System.getProperties().put("sonar.tests", "src/test");
            System.getProperties().put("sonar.scoverage.reportPath", p.getBuildDir() + "/reports/scoverage/scoverage.xml");
            System.getProperties().put("sonar.jacoco.reportPaths", p.getBuildDir() + "/jacoco/test.exec");
            System.getProperties().put("sonar.github.repository", sonar.githubRepository);
            System.getProperties().put("sonar.sources", sonar.sources);
        });
    }
}

