/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.gradle;

import com.mulesoft.gradle.UpstartPlugin;
import com.mulesoft.gradle.common.EnvironmentConstants;
import com.netflix.gradle.plugins.application.OspackageApplicationPlugin;
import com.netflix.gradle.plugins.packaging.ProjectPackagingExtension;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.jvm.application.tasks.CreateStartScripts;
import org.gradle.tooling.BuildException;
import org.redline_rpm.header.Os;

public class JVMServicePlugin
implements Plugin<Project> {
    private static final String POST_INSTALL = "update-alternatives --set java /usr/lib/jvm/jre-1.8.0-openjdk.x86_64/bin/java";

    public void apply(Project project) {
        OspackageApplicationPlugin applicationPlugin = (OspackageApplicationPlugin)project.getPlugins().apply(OspackageApplicationPlugin.class);
        String environmentPath = EnvironmentConstants.ENV_FILE_PATH.value() + project.getName() + "/";
        String command = "script\ntouch " + environmentPath + project.getName() + ".sh\nmkdir -p " + EnvironmentConstants.LOG_FILE_PATH.value() + project.getName() + "\nexec bash -c 'source " + environmentPath + project.getName() + ".sh && " + applicationPlugin.getExtension().getPrefix() + "/" + project.getName() + "/bin/" + project.getName() + " >> " + EnvironmentConstants.LOG_FILE_PATH.value() + project.getName() + "/" + project.getName() + ".log 2>&1'\nend script";
        UpstartPlugin upstartPlugin = new UpstartPlugin(command);
        project.getPlugins().add((Object)upstartPlugin);
        project.afterEvaluate(p -> {
            ProjectPackagingExtension ext = (ProjectPackagingExtension)p.getExtensions().findByType(ProjectPackagingExtension.class);
            ext.requires("java-1.8.0-openjdk");
            ext.setArch((Object)"x86_64");
            ext.setOs(Os.LINUX);
            ext.setUser(EnvironmentConstants.USR_NAME.value());
            ext.setRelease(System.getenv(EnvironmentConstants.BUILD_NUMBER.value()));
            String branchName = System.getenv(EnvironmentConstants.BRANCH_NAME.value());
            ext.setPackageName(p.getName() + (branchName != null ? "-" + branchName : ""));
            ext.preInstall(this.preInstall(p.getName()));
            ext.postInstall(POST_INSTALL);
            ArrayList<String> jvmArgs = new ArrayList<String>();
            jvmArgs.add("-Djava.net.preferIPv4Stack=true");
            p.getConvention().getExtensionsAsDynamicObject().setProperty("applicationDefaultJvmArgs", jvmArgs);
            CreateStartScripts startScripts = (CreateStartScripts)p.getTasks().findByName("startScripts");
            startScripts.doLast(task -> {
                List<String> lines = null;
                String envScript = environmentPath + p.getName() + ".sh";
                String extraLine = "##### Read config vars\nif [ -e " + envScript + " ]; then . " + envScript + ";fi\n";
                try {
                    Path path = ((CreateStartScripts)task).getUnixScript().toPath();
                    lines = Files.readAllLines(path, StandardCharsets.UTF_8);
                    lines.add(lines.size() - 1, extraLine);
                    Files.write(path, lines, StandardCharsets.UTF_8, new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new BuildException(e.getMessage(), (Throwable)e);
                }
            });
        });
    }

    private String preInstall(String projectName) {
        return "mkdir -p " + EnvironmentConstants.ENV_FILE_PATH.value() + projectName + "/";
    }
}

