/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.gradle;

import com.mulesoft.gradle.NodeServiceExtension;
import com.mulesoft.gradle.UpstartPlugin;
import com.mulesoft.gradle.common.EnvironmentConstants;
import com.netflix.gradle.plugins.rpm.Rpm;
import com.netflix.gradle.plugins.rpm.RpmPlugin;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.redline_rpm.header.Os;

public class NodeServicePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(RpmPlugin.class);
        project.getExtensions().create("nodeService", NodeServiceExtension.class, new Object[0]);
        project.afterEvaluate(p -> {
            NodeServiceExtension nodeService = (NodeServiceExtension)p.getExtensions().getByType(NodeServiceExtension.class);
            String environmentPath = EnvironmentConstants.ENV_FILE_PATH.value() + p.getName() + "/";
            String command = "chdir /usr/" + project.getName() + "\nscript\nif [ ! -e " + EnvironmentConstants.LOG_FILE_PATH.value() + project.getName() + " ]; then\n/bin/mkdir  " + EnvironmentConstants.LOG_FILE_PATH.value() + project.getName() + "\nfi\ntouch " + environmentPath + p.getName() + ".sh\nexec bash -c 'source " + environmentPath + p.getName() + ".sh && source ~/.nvm/nvm.sh && nvm use v" + nodeService.nodeVersion + " && node " + nodeService.entryPoint + " >> " + EnvironmentConstants.LOG_FILE_PATH.value() + project.getName() + "/" + project.getName() + ".log 2>&1 '\nend script";
            UpstartPlugin upstartPlugin = new UpstartPlugin(command);
            project.getPlugins().add((Object)upstartPlugin);
            Rpm rpm = (Rpm)project.getTasks().create("buildRpm", Rpm.class);
            if (p.getPlugins().hasPlugin("com.moowork.node")) {
                rpm.dependsOn(new Object[]{project.getTasks().getByName("npmInstall")});
            }
            rpm.requires("man");
            rpm.requires("upstart");
            rpm.requires("which");
            rpm.setArch((Object)"x86_64");
            rpm.setOs(Os.LINUX);
            rpm.setUser(EnvironmentConstants.USR_NAME.value());
            String branchName = System.getenv(EnvironmentConstants.BRANCH_NAME.value());
            rpm.setPackageName(p.getName() + (branchName != null ? "-" + branchName : ""));
            rpm.into((Object)(EnvironmentConstants.USR_PATH.value() + p.getName()), copySpec -> copySpec.from(new Object[]{nodeService.entryPoint, "./package.json"}));
            rpm.into((Object)(EnvironmentConstants.USR_PATH.value() + p.getName() + "/src"), copySpec -> copySpec.from(new Object[]{"src"}).exclude(new String[]{"**/*.ts"}));
            rpm.into((Object)(EnvironmentConstants.USR_PATH.value() + p.getName() + "/config"), copySpec -> copySpec.from(new Object[]{"config"}).exclude(new String[]{"**/*.ts"}));
            rpm.into((Object)(EnvironmentConstants.USR_PATH.value() + p.getName() + "/node_modules"), copySpec -> copySpec.from(new Object[]{"node_modules"}).exclude(new String[]{"**/*.ts"}));
            rpm.preInstall(this.preInstall(p.getName()));
            rpm.postInstall(this.postInstall(nodeService.nodeVersion));
        });
    }

    private String preInstall(String projectName) {
        return "mkdir -p " + EnvironmentConstants.ENV_FILE_PATH.value() + projectName + "/";
    }

    private String postInstall(String nodeVersion) {
        return "touch ~/.bash_profile\ncurl https://raw.githubusercontent.com/creationix/nvm/v0.13.1/install.sh | bash\nsource ~/.bash_profile\nnvm install v" + nodeVersion;
    }
}

