/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.gradle;

import com.mulesoft.gradle.DaemonTemplateTask;
import com.mulesoft.gradle.common.EnvironmentConstants;
import com.netflix.gradle.plugins.packaging.ProjectPackagingExtension;
import com.netflix.gradle.plugins.packaging.SystemPackagingBasePlugin;
import com.netflix.gradle.plugins.packaging.SystemPackagingTask;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class UpstartPlugin
implements Plugin<Project> {
    Project project;
    private String command;

    public UpstartPlugin(String command) {
        this.command = command;
    }

    public void apply(Project project) {
        this.project = project;
        project.getPlugins().apply(SystemPackagingBasePlugin.class);
        project.getTasks().withType(SystemPackagingTask.class, task -> {
            ProjectPackagingExtension ext = (ProjectPackagingExtension)project.getExtensions().findByType(ProjectPackagingExtension.class);
            ext.requires("upstart");
            String cleanedName = StringUtils.capitalize((String)project.getName().replaceAll("\\W", ""));
            File outputDir = new File(project.getBuildDir(), "daemon/" + cleanedName);
            DaemonTemplateTask templateTask = (DaemonTemplateTask)project.getTasks().create(task.getName() + cleanedName + "Daemon", DaemonTemplateTask.class);
            templateTask.setDestDir(outputDir);
            HashMap<String, String> context = new HashMap<String, String>();
            context.put(EnvironmentConstants.APP_NAME.value(), project.getName());
            context.put(EnvironmentConstants.COMMAND.value(), this.command);
            templateTask.setContext(context);
            task.dependsOn(new Object[]{templateTask});
            File rendered = new File(outputDir, "upstart.conf");
            String destFile = project.getName() + ".conf";
            task.from((Object)rendered, copySpec -> {
                copySpec.into((Object)"/etc/init");
                copySpec.rename(".*", destFile);
                copySpec.setFileMode(Integer.valueOf(365));
            });
        });
    }
}

