/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.gradle;

import com.mulesoft.gradle.SonarPluginExtension;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class SonarPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        SonarPluginExtension sonar = (SonarPluginExtension)project.getExtensions().create("sonar", SonarPluginExtension.class, new Object[]{project.getName()});
        project.getPlugins().apply("org.sonarqube");
        System.getProperties().put("sonar.host.url", System.getProperty("SONAR_USR"));
        System.getProperties().put("sonar.login", System.getProperty("SONAR_PSW"));
        System.getProperties().put("sonar.projectKey", "mulesoft." + project.getName());
        System.getProperties().put("sonar.projectName", project.getDescription());
        System.getProperties().put("sonar.projectVersion", project.getVersion());
        System.getProperties().put("sonar.sourceEncoding", "UTF-8");
        System.getProperties().put("sonar.exclusions", "src/test/resources/**");
        System.getProperties().put("sonar.tests", "src/test");
        System.getProperties().put("sonar.scoverage.reportPath", project.getBuildDir() + "/reports/scoverage/scoverage.xml");
        System.getProperties().put("sonar.github.repository", sonar.githubRepository);
    }
}

