/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.gradle;

import com.mulesoft.gradle.NexusIqExtension;
import com.sonatype.insight.scan.cli.PolicyEvaluatorCli;
import org.apache.log4j.Logger;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;

public class NexusIqPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getTasks().create("nexusIq", NexusIqTask.class);
        project.getExtensions().create("nexusIq", NexusIqExtension.class, new Object[0]);
        try {
            Class<?> clazz = Class.forName("com.sonatype.insight.scan.cli.PolicyEvaluatorCli");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Nexus IQ cli jar not found in classpath. Download it from https://help.sonatype.com/display/NXIQ/Download+and+Compatibility");
        }
    }

    public static class NexusIqTask
    extends DefaultTask {
        public String getName() {
            return "nexusIq";
        }

        public String getDescription() {
            return "NexusIQ CLI";
        }

        @TaskAction
        public void nexusIq() {
            String name = this.getProject().getName();
            NexusIqExtension ext = (NexusIqExtension)this.getProject().getExtensions().findByType(NexusIqExtension.class);
            String user = ext.user;
            String password = ext.password;
            String url = ext.url;
            try {
                PolicyEvaluatorCli.main((String[])new String[]{"-i", name, "-s", url, "-a", user + ":" + password, this.getProject().getBuildDir().getPath() + "/distributions/" + name + ".zip"});
            }
            catch (Exception e) {
                Logger.getLogger(NexusIqPlugin.class).error((Object)e.getMessage());
            }
        }
    }
}

