/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.gradle;

import com.mulesoft.gradle.ExitTrappedException;
import com.mulesoft.gradle.NexusIqExtension;
import com.sonatype.insight.scan.cli.PolicyEvaluatorCli;
import java.security.Permission;
import org.apache.log4j.Logger;
import org.gradle.api.DefaultTask;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.TaskAction;

public class NexusIqPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getTasks().create("nexusIq", NexusIqTask.class);
        project.getExtensions().create("nexusIq", NexusIqExtension.class, new Object[0]);
        try {
            Class<?> clazz = Class.forName("com.sonatype.insight.scan.cli.PolicyEvaluatorCli");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Nexus IQ cli jar not found in classpath. Download it from https://help.sonatype.com/display/NXIQ/Download+and+Compatibility");
        }
    }

    private static void forbidSystemExitCall() {
        SecurityManager securityManager = new SecurityManager(){

            @Override
            public void checkPermission(Permission permission) {
                if (permission.getName().startsWith("exitVM")) {
                    throw new ExitTrappedException();
                }
            }
        };
        System.setSecurityManager(securityManager);
    }

    private static void enableSystemExitCall() {
        System.setSecurityManager(null);
    }

    public static class NexusIqTask
    extends DefaultTask {
        public String getName() {
            return "nexusIq";
        }

        public String getDescription() {
            return "NexusIQ CLI";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @TaskAction
        public void nexusIq() {
            String name = this.getProject().getName();
            NexusIqExtension ext = (NexusIqExtension)this.getProject().getExtensions().findByType(NexusIqExtension.class);
            String user = ext.user;
            String password = ext.password;
            String url = ext.url;
            try {
                NexusIqPlugin.forbidSystemExitCall();
                String artifactPath = "".equals(ext.artifact) ? this.getProject().getBuildDir().getPath() + "/distributions/" + name + ".zip" : ext.artifact;
                PolicyEvaluatorCli.main((String[])new String[]{"-e", "-i", name, "-s", url, "-a", user + ":" + password, artifactPath});
            }
            catch (ExitTrappedException e) {
                Logger.getLogger(NexusIqPlugin.class).debug((Object)"NexusIQ exited");
            }
            finally {
                NexusIqPlugin.enableSystemExitCall();
            }
        }
    }
}

