#!/bin/bash
${extraLines}
export SALT_ROLE=${roleName}
CONF_FILE=/etc/${appName}/${appName}.sh
/usr/local/bin/provision.sh
salt-call pillar.items ${roleName}_profile --output=json | jq '.local."${roleName}_profile" | to_entries | map(["export " + .key, "\"" + .value + "\""] | join("=")) | join("\n") | @text' -r >> \$CONF_FILE
if [ -s \${CONF_FILE} ]; then
  initctl emit env
else
  echo "[ERROR]: Configuration file \${CONF_FILE} not found"
  logger -p local6.error "Configuration file \${CONF_FILE} not found"
  exit 1
fi