/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.gradle;

import com.bmuschko.gradle.docker.DockerExtension;
import com.bmuschko.gradle.docker.DockerJavaApplication;
import com.bmuschko.gradle.docker.DockerRegistryCredentials;
import com.mulesoft.gradle.BaseDockerPlugin;
import com.mulesoft.gradle.DockerPluginExtension;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;

public class JVMDockerServicePlugin
extends BaseDockerPlugin {
    @Override
    public void apply(Project project) {
        super.apply(project);
        project.afterEvaluate(p -> {
            DockerExtension dockerExt = (DockerExtension)p.getExtensions().findByType(DockerExtension.class);
            DockerJavaApplication dockerJavaApplication = (DockerJavaApplication)((ExtensionAware)dockerExt).getExtensions().findByType(DockerJavaApplication.class);
            DockerPluginExtension docker = (DockerPluginExtension)p.getExtensions().findByType(DockerPluginExtension.class);
            dockerJavaApplication.setBaseImage("devdocker.mulesoft.com:18078/mulesoft/core-paas-base-image-openjdk-8");
            dockerJavaApplication.setMaintainer("mulesoft.com");
            dockerJavaApplication.setPorts(docker.ports);
            dockerJavaApplication.setTag(docker.tag);
            DockerJavaApplication.CompositeExecInstruction exec = dockerJavaApplication.getExecInstruction();
            exec.defaultCommand(new String[]{p.getName() + "/bin/" + project.getName()});
            exec.entryPoint(new String[]{"/docker-entrypoint.sh"});
            DockerRegistryCredentials registryCredentials = new DockerRegistryCredentials();
            registryCredentials.setUrl(docker.registry);
            registryCredentials.setUsername(System.getProperty("DOCKER_USER"));
            registryCredentials.setPassword(System.getProperty("DOCKER_PASS"));
            registryCredentials.setEmail(System.getProperty("DOCKER_EMAIL"));
            dockerExt.setRegistryCredentials(registryCredentials);
        });
    }
}

