/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.gradle;

import com.mulesoft.gradle.EC2PluginExtension;
import com.mulesoft.gradle.UserDataTemplateTask;
import com.mulesoft.gradle.common.EnvironmentConstants;
import com.netflix.gradle.plugins.packaging.SystemPackagingBasePlugin;
import com.netflix.gradle.plugins.packaging.SystemPackagingTask;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class EC2Plugin
implements Plugin<Project> {
    Project project;

    public void apply(Project project) {
        this.project = project;
        project.getPlugins().apply(SystemPackagingBasePlugin.class);
        project.getExtensions().create("ec2", EC2PluginExtension.class, new Object[0]);
        project.getTasks().withType(SystemPackagingTask.class, task -> {
            String cleanedName = StringUtils.capitalize((String)project.getName().replaceAll("\\W", ""));
            File outputDir = new File(project.getBuildDir(), "userData/" + cleanedName);
            UserDataTemplateTask templateTask = (UserDataTemplateTask)project.getTasks().create(task.getName() + cleanedName + "EC2Data", UserDataTemplateTask.class);
            templateTask.setDestDir(outputDir);
            HashMap<String, String> context = new HashMap<String, String>();
            context.put(EnvironmentConstants.APP_NAME.value(), project.getName());
            templateTask.setContext(context);
            task.dependsOn(new Object[]{templateTask});
            File rendered = new File(outputDir, "ec2-init.sh");
            String destFile = "ec2-init.sh";
            task.from((Object)rendered, copySpec -> {
                copySpec.into((Object)"/opt");
                copySpec.rename(".*", destFile);
                copySpec.setFileMode(Integer.valueOf(365));
            });
        });
    }
}

