/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.gradle;

import com.mulesoft.BaseServicePlugin;
import com.mulesoft.gradle.EC2Plugin;
import com.mulesoft.gradle.GenericServiceExtension;
import com.mulesoft.gradle.UpstartPlugin;
import com.mulesoft.gradle.UpstartPluginExtension;
import com.mulesoft.gradle.common.EnvironmentConstants;
import com.netflix.gradle.plugins.rpm.Rpm;
import com.netflix.gradle.plugins.rpm.RpmPlugin;
import org.gradle.api.Project;
import org.redline_rpm.header.Os;

public class GenericServicePlugin
extends BaseServicePlugin {
    @Override
    public void apply(Project project) {
        super.apply(project);
        project.getPlugins().apply(RpmPlugin.class);
        project.getExtensions().create("genericService", GenericServiceExtension.class, new Object[0]);
        Rpm rpm = (Rpm)project.getTasks().create("buildRpm", Rpm.class);
        project.getPluginManager().apply(EC2Plugin.class);
        project.afterEvaluate(p -> {
            GenericServiceExtension nodeService = (GenericServiceExtension)p.getExtensions().getByType(GenericServiceExtension.class);
            String environmentPath = EnvironmentConstants.ENV_FILE_PATH.value() + p.getName() + "/";
            project.getPlugins().apply(UpstartPlugin.class);
            UpstartPluginExtension extension = (UpstartPluginExtension)project.getExtensions().getByType(UpstartPluginExtension.class);
            extension.command = nodeService.command;
            extension.runAsUser = nodeService.runAsUser;
            if (p.getPlugins().hasPlugin("com.moowork.node")) {
                rpm.dependsOn(new Object[]{project.getTasks().getByName("npmInstall")});
            }
            rpm.requires("man");
            rpm.requires("upstart");
            rpm.requires("which");
            rpm.setArch((Object)"x86_64");
            rpm.setOs(Os.LINUX);
            String runAsUser = nodeService.runAsUser != null ? nodeService.runAsUser : EnvironmentConstants.ROOT_USER.value();
            rpm.setUser(runAsUser);
            String branchName = System.getenv(EnvironmentConstants.BRANCH_NAME.value());
            rpm.setPackageName(p.getName() + (branchName != null ? "-" + branchName : ""));
        });
    }
}

