/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.gradle;

import com.mulesoft.BaseServicePlugin;
import com.mulesoft.gradle.EC2Plugin;
import com.mulesoft.gradle.JVMServicePluginExtension;
import com.mulesoft.gradle.NewRelicPluginExtension;
import com.mulesoft.gradle.UpstartPlugin;
import com.mulesoft.gradle.UpstartPluginExtension;
import com.mulesoft.gradle.VersionFileGeneratorTask;
import com.mulesoft.gradle.common.EnvironmentConstants;
import com.netflix.gradle.plugins.application.OspackageApplicationPlugin;
import com.netflix.gradle.plugins.packaging.ProjectPackagingExtension;
import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.ApplicationPlugin;
import org.gradle.jvm.application.tasks.CreateStartScripts;
import org.gradle.tooling.BuildException;
import org.redline_rpm.header.Os;

public class JVMServicePlugin
extends BaseServicePlugin {
    private final String IPV4_ARG = "-Djava.net.preferIPv4Stack=true";
    private static final String POST_INSTALL = "update-alternatives --set java /usr/lib/jvm/jre-1.8.0-openjdk.x86_64/bin/java";
    private static final String NEW_RELIC_YAML = "common: &default_settings\n    error_collector:\n        enabled: true\n";

    @Override
    public void apply(final Project project) {
        super.apply(project);
        OspackageApplicationPlugin ospackageApplicationPlugin = (OspackageApplicationPlugin)project.getPlugins().apply(OspackageApplicationPlugin.class);
        project.getPlugins().apply(ApplicationPlugin.class);
        project.getExtensions().create("service", JVMServicePluginExtension.class, new Object[0]);
        NewRelicPluginExtension newRelic = (NewRelicPluginExtension)project.getExtensions().create("newRelic", NewRelicPluginExtension.class, new Object[0]);
        String environmentPath = EnvironmentConstants.ENV_FILE_PATH.value() + project.getName() + "/";
        final String applicationPath = ospackageApplicationPlugin.getExtension().getPrefix() + "/" + project.getName();
        String command = "script\ntouch " + environmentPath + project.getName() + ".sh\nmkdir -p " + EnvironmentConstants.LOG_FILE_PATH.value() + project.getName() + "\nexec bash -c 'source " + environmentPath + project.getName() + ".sh && " + applicationPath + "/bin/" + project.getName() + " >> " + EnvironmentConstants.LOG_FILE_PATH.value() + project.getName() + "/" + project.getName() + ".log 2>&1'\nend script";
        project.getPlugins().apply(UpstartPlugin.class);
        UpstartPluginExtension extension = (UpstartPluginExtension)project.getExtensions().getByType(UpstartPluginExtension.class);
        extension.command = command;
        project.getPlugins().apply(EC2Plugin.class);
        VersionFileGeneratorTask generateVersionFile = (VersionFileGeneratorTask)project.getTasks().create("generateVersionFile", VersionFileGeneratorTask.class);
        ((Task)project.getTasks().findByName("jar")).dependsOn(new Object[]{generateVersionFile});
        ((Task)project.getTasks().findByName("run")).doFirst(new Closure(this){

            public void doCall() {
                ArrayList applicationDefaultJvmArgs = (ArrayList)project.getConvention().getExtensionsAsDynamicObject().getProperty("applicationDefaultJvmArgs");
                applicationDefaultJvmArgs.removeIf(s -> s.startsWith("-javaagent:" + applicationPath));
            }
        });
        project.afterEvaluate(p -> {
            ProjectPackagingExtension ext = (ProjectPackagingExtension)p.getExtensions().findByType(ProjectPackagingExtension.class);
            ext.requires("java-1.8.0-openjdk");
            ext.setArch((Object)"x86_64");
            ext.setOs(Os.LINUX);
            ext.setUser(EnvironmentConstants.ROOT_USER.value());
            String branchName = System.getenv(EnvironmentConstants.BRANCH_NAME.value());
            ext.setPackageName(p.getName() + (branchName != null ? "-" + branchName : ""));
            ext.preInstall(this.preInstall(p.getName()));
            ext.postInstall(POST_INSTALL);
            System.getProperties().put("sonar.tests", "src/test");
            ArrayList jvmArgs = (ArrayList)project.getConvention().getExtensionsAsDynamicObject().getProperty("applicationDefaultJvmArgs");
            jvmArgs.add("-Djava.net.preferIPv4Stack=true");
            if (newRelic.enabled) {
                String agentFileName;
                String agentDep;
                String appPath = ospackageApplicationPlugin.getExtension().getPrefix() + "/" + project.getName();
                if (newRelic.customNewRelicLib && !newRelic.customNewRelicLibPath.trim().isEmpty()) {
                    agentDep = project.files(new Object[]{newRelic.customNewRelicLibPath});
                    agentFileName = new File(newRelic.customNewRelicLibPath).getName();
                } else {
                    agentDep = "com.newrelic.agent.java:newrelic-agent:" + newRelic.version;
                    agentFileName = "newrelic-agent-" + newRelic.version + ".jar";
                }
                project.getDependencies().add("runtime", (Object)agentDep);
                jvmArgs.add("-javaagent:" + appPath + "/lib/" + agentFileName);
                jvmArgs.add("-Dnewrelic.config.file=" + appPath + "/bin/newrelic.yml");
            }
            p.getConvention().getExtensionsAsDynamicObject().setProperty("applicationDefaultJvmArgs", (Object)jvmArgs);
            CreateStartScripts startScripts = (CreateStartScripts)p.getTasks().findByName("startScripts");
            startScripts.doLast(task -> {
                List<String> lines = null;
                String envScript = environmentPath + p.getName() + ".sh";
                String extraLine = "##### Read config vars\nif [ -e " + envScript + " ]; then . " + envScript + ";fi\n";
                try {
                    File unixScript = ((CreateStartScripts)task).getUnixScript();
                    Path path = unixScript.toPath();
                    lines = Files.readAllLines(path, StandardCharsets.UTF_8);
                    lines.add(lines.size() - 1, extraLine);
                    String exec = "if [ -n \"$EXTRA_JVM_ARGS\" ]; then\n  exec \"$JAVACMD\" \"$EXTRA_JVM_ARGS\" \"$@\"\nelse\n  exec \"$JAVACMD\" \"$@\"\nfi";
                    lines.set(lines.size() - 1, exec);
                    Files.write(path, lines, StandardCharsets.UTF_8, new OpenOption[0]);
                    if (newRelic.enabled) {
                        File newRelicDestConf = new File(unixScript.getParent(), "newrelic.yml");
                        if (newRelic.customNewRelicFile && !newRelic.customNewRelicFilePath.trim().isEmpty()) {
                            File newRelicConf = new File(p.getRootDir() + newRelic.customNewRelicFilePath);
                            FileUtils.copyFile((File)newRelicConf, (File)newRelicDestConf);
                        } else {
                            Files.write(newRelicDestConf.toPath(), this.getNewRelicYaml(newRelic.expectClientErrors).getBytes(), new OpenOption[0]);
                        }
                    }
                }
                catch (IOException e) {
                    throw new BuildException(e.getMessage(), (Throwable)e);
                }
            });
        });
    }

    private String getNewRelicYaml(boolean ignoreClientErrors) {
        return NEW_RELIC_YAML + (ignoreClientErrors ? "        expected_status_codes: 400-409\n" : "");
    }

    private String preInstall(String projectName) {
        return "mkdir -p " + EnvironmentConstants.ENV_FILE_PATH.value() + projectName + "/";
    }
}

