/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.gradle;

import com.mulesoft.gradle.DaemonTemplateTask;
import com.mulesoft.gradle.UpstartPluginExtension;
import com.mulesoft.gradle.common.EnvironmentConstants;
import com.netflix.gradle.plugins.packaging.ProjectPackagingExtension;
import com.netflix.gradle.plugins.packaging.SystemPackagingBasePlugin;
import com.netflix.gradle.plugins.packaging.SystemPackagingTask;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class UpstartPlugin
implements Plugin<Project> {
    Project project;

    public void apply(Project project) {
        this.project = project;
        project.getPlugins().apply(SystemPackagingBasePlugin.class);
        project.getExtensions().create("upstart", UpstartPluginExtension.class, new Object[0]);
        project.afterEvaluate(p -> p.getTasks().withType(SystemPackagingTask.class, task -> {
            UpstartPluginExtension extension = (UpstartPluginExtension)p.getExtensions().getByType(UpstartPluginExtension.class);
            ProjectPackagingExtension ext = (ProjectPackagingExtension)p.getExtensions().findByType(ProjectPackagingExtension.class);
            ext.requires("upstart");
            String cleanedName = StringUtils.capitalize((String)p.getName().replaceAll("\\W", ""));
            File outputDir = new File(p.getBuildDir(), "daemon/" + cleanedName);
            DaemonTemplateTask templateTask = (DaemonTemplateTask)project.getTasks().create(task.getName() + cleanedName + "Daemon", DaemonTemplateTask.class);
            templateTask.setDestDir(outputDir);
            if (extension.customUpstartConf != null) {
                templateTask.setCustomUpstartConf(extension.customUpstartConf);
            }
            HashMap<String, String> context = new HashMap<String, String>();
            context.put(EnvironmentConstants.APP_NAME.value(), p.getName());
            context.put(EnvironmentConstants.COMMAND.value(), extension.command);
            context.put(EnvironmentConstants.RUN_AS_USER.value(), extension.runAsUser != null ? extension.runAsUser : EnvironmentConstants.ROOT_USER.value());
            templateTask.setContext(context);
            task.dependsOn(new Object[]{templateTask});
            File rendered = new File(outputDir, "upstart.conf");
            String destFile = project.getName() + ".conf";
            task.from((Object)rendered, copySpec -> {
                copySpec.into((Object)"/etc/init");
                copySpec.rename(".*", destFile);
                copySpec.setFileMode(Integer.valueOf(365));
            });
        }));
    }
}

