/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.gradle;

import com.netflix.gradle.plugins.daemon.TemplateHelper;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;

class DaemonTemplateTask
extends ConventionTask {
    private Map<String, String> context;
    private File destDir;
    private String customUpstartConf;

    @Input
    public Map<String, String> getContext() {
        return this.context;
    }

    @Input
    public File getDestDir() {
        return this.destDir;
    }

    public void setDestDir(File dir) {
        this.destDir = dir;
    }

    public void setCustomUpstartConf(String upstartConf) {
        this.customUpstartConf = upstartConf;
    }

    public void setContext(Map<String, String> map) {
        this.context = map;
    }

    @TaskAction
    public void template() {
        if (this.customUpstartConf != null) {
            try {
                File upstartFile = new File(this.getProject().getRootDir() + this.customUpstartConf);
                File destFile = new File(this.destDir, "upstart.conf");
                FileUtils.copyFile((File)upstartFile, (File)destFile);
            }
            catch (IOException e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        } else {
            TemplateHelper templateHelper = new TemplateHelper(this.destDir, "/com/mulesoft/gradle/plugins/daemon", this.getProject());
            templateHelper.generateFile("upstart.conf", this.context);
        }
    }

    @OutputFile
    File getTemplatesOutout() {
        return new File(this.destDir, "upstart.conf");
    }
}

