/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.habitat.plugin;

import com.mulesoft.habitat.agent.api.AnypointApplication;
import com.mulesoft.habitat.agent.api.AnypointClient;
import com.mulesoft.habitat.agent.endpoint.AnypointEnabledEndpointFactory;
import com.mulesoft.habitat.plugin.PluginAnypointApplication;
import com.mulesoft.mule.plugin.classloader.ClassLoaderInjectorInvocationHandler;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.mule.api.MuleContext;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.RegistrationException;
import org.mule.module.launcher.AbstractDeploymentListener;

public class AnypointDeploymentListener
extends AbstractDeploymentListener {
    public static final String MULE_ENDPOINT_FACTORY_KEY = "_muleEndpointFactory";
    public static final String ANYPOINT_APPLICATION_ERROR_TEMPLATE = "Error adding Anypoint plugin management for aplication '%s'. Application will run without Anypoint support";
    private static final Logger LOGGER = Logger.getLogger(AnypointDeploymentListener.class);
    private final AnypointClient anypointClient;
    private final Map<String, AnypointApplication> applications = new HashMap<String, AnypointApplication>();

    public AnypointDeploymentListener(AnypointClient anypointClient) {
        this.anypointClient = anypointClient;
    }

    public void onMuleContextCreated(String appName, MuleContext context) {
        AnypointEnabledEndpointFactory anypointEnabledEndpointFactory = new AnypointEnabledEndpointFactory();
        Object proxy = ClassLoaderInjectorInvocationHandler.createProxy((Object)anypointEnabledEndpointFactory, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (Class[])new Class[]{EndpointFactory.class});
        try {
            context.getRegistry().registerObject(MULE_ENDPOINT_FACTORY_KEY, proxy);
        }
        catch (RegistrationException e) {
            this.logApplicationPluginSetupError(appName, (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDeploymentSuccess(String appName) {
        Map<String, AnypointApplication> map = this.applications;
        synchronized (map) {
            AnypointApplication anypointApplication = this.applications.get(appName);
            if (anypointApplication != null) {
                this.anypointClient.addAnypointApplication(anypointApplication);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUndeploymentStart(String appName) {
        Map<String, AnypointApplication> map = this.applications;
        synchronized (map) {
            AnypointApplication anypointApplication = this.applications.remove(appName);
            if (anypointApplication != null) {
                this.anypointClient.removeAnypointApplication(anypointApplication);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMuleContextConfigured(String appName, MuleContext context) {
        try {
            PluginAnypointApplication anypointApplication = new PluginAnypointApplication(context, this.anypointClient);
            Map<String, AnypointApplication> map = this.applications;
            synchronized (map) {
                this.applications.put(appName, (AnypointApplication)anypointApplication);
            }
        }
        catch (InitialisationException e) {
            this.logApplicationPluginSetupError(appName, (Exception)((Object)e));
        }
    }

    private void logApplicationPluginSetupError(String appName, Exception cause) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)String.format(ANYPOINT_APPLICATION_ERROR_TEMPLATE, appName), (Throwable)cause);
        } else if (LOGGER.isInfoEnabled()) {
            LOGGER.warn((Object)String.format(ANYPOINT_APPLICATION_ERROR_TEMPLATE, appName));
        }
    }
}

