/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.habitat.endpoint.resolver;

import com.mulesoft.habitat.agent.api.EndpointLocationResolver;
import com.mulesoft.habitat.agent.api.UnableToResolveContractException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.EndpointFactory;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.IdentifiableDynamicRouteResolver;
import org.mule.routing.RouteResolverException;

public abstract class AbstractServiceResolver
implements IdentifiableDynamicRouteResolver,
MuleContextAware,
Initialisable {
    private static final Logger LOGGER = Logger.getLogger(AbstractServiceResolver.class);
    private ExpressionManager expressionManager;
    private EndpointLocationResolver endpointLocationResolver;
    private EndpointFactory endpointFactory;
    private MuleContext muleContext;

    public void initialise() throws InitialisationException {
        this.expressionManager = this.muleContext.getExpressionManager();
        this.endpointFactory = this.muleContext.getEndpointFactory();
    }

    public String getRouteIdentifier(MuleEvent event) throws MessagingException {
        return this.getMetadataUniqueId(this.evaluateServiceIdentificationMetadata(event));
    }

    public List<MessageProcessor> resolveRoutes(MuleEvent event) throws MessagingException {
        try {
            Map<String, String> resolvedMetadata = this.evaluateServiceIdentificationMetadata(event);
            List<String> outboundEndpointsUris = this.resolveUrisFromMetadata(event, resolvedMetadata);
            return this.createEndpointsFromUris(outboundEndpointsUris);
        }
        catch (Exception e) {
            throw new RouteResolverException(event, (Throwable)e);
        }
    }

    protected abstract Map<String, String> getSpecificServiceMetadata();

    private Map<String, String> evaluateServiceIdentificationMetadata(MuleEvent event) {
        return this.resolveMetadata(this.getSpecificServiceMetadata(), event);
    }

    private List<String> resolveUrisFromMetadata(MuleEvent event, Map<String, String> resolvedMetadata) throws MessagingException {
        List outboundEndpointsUris = Collections.emptyList();
        try {
            List endpointAddress = this.getEndpointLocationResolver().resolveAddress(resolvedMetadata, null);
            if (endpointAddress != null) {
                outboundEndpointsUris = endpointAddress;
            }
        }
        catch (UnableToResolveContractException e) {
            throw new MessagingException(event, (Throwable)e);
        }
        catch (NoEndpointResolverException e) {
            throw new MessagingException(CoreMessages.createStaticMessage((String)"Could not find dynamic route. No service resolver found in application. Seems Service Registry agent is not properly configured."), event, (Throwable)((Object)e));
        }
        if (outboundEndpointsUris.size() > 0) {
            Collections.sort(outboundEndpointsUris);
        }
        return outboundEndpointsUris;
    }

    private List<MessageProcessor> createEndpointsFromUris(List<String> uris) throws MuleException {
        LinkedList<MessageProcessor> outboundEndpoints = new LinkedList<MessageProcessor>();
        for (String uri : uris) {
            OutboundEndpoint outboundEndpoint = this.endpointFactory.getOutboundEndpoint(uri);
            outboundEndpoints.add((MessageProcessor)outboundEndpoint);
        }
        return outboundEndpoints;
    }

    private String getMetadataUniqueId(Map<String, String> resolvedMetadata) {
        StringBuilder metadataUniqueId = new StringBuilder();
        for (String key : resolvedMetadata.keySet()) {
            metadataUniqueId.append(key + ":" + resolvedMetadata.get(key));
        }
        return metadataUniqueId.toString();
    }

    private synchronized EndpointLocationResolver getEndpointLocationResolver() throws NoEndpointResolverException {
        if (this.endpointLocationResolver == null) {
            try {
                this.endpointLocationResolver = (EndpointLocationResolver)this.muleContext.getRegistry().lookupObject(EndpointLocationResolver.class);
            }
            catch (RegistrationException e) {
                LOGGER.warn((Object)("Could not retrieve DefaultEndpointLocationResolver from the registry: " + e.getMessage()), (Throwable)e);
                return null;
            }
        }
        if (this.endpointLocationResolver == null) {
            throw new NoEndpointResolverException();
        }
        return this.endpointLocationResolver;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    protected String resolveAttributeValue(String value, MuleEvent event) {
        if (this.expressionManager.isExpression(value)) {
            return this.expressionManager.parse(value, event);
        }
        return value;
    }

    protected Map<String, String> resolveMetadata(Map<String, String> rawMetadata, MuleEvent event) {
        HashMap<String, String> evaluatedMetadata = new HashMap<String, String>();
        for (String key : rawMetadata.keySet()) {
            evaluatedMetadata.put(key, this.resolveAttributeValue(rawMetadata.get(key), event));
        }
        return evaluatedMetadata;
    }

    private static class NoEndpointResolverException
    extends MuleException {
        public NoEndpointResolverException() {
            super(CoreMessages.createStaticMessage((String)"No route resolver found in application"));
        }
    }
}

