/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.habitat.plugin;

import com.mulesoft.habitat.agent.AnypointAgentUtils;
import com.mulesoft.habitat.agent.AnypointClientFactory;
import com.mulesoft.habitat.agent.api.AnypointClient;
import com.mulesoft.habitat.agent.api.MuleContextScanner;
import com.mulesoft.habitat.plugin.AnypointDeploymentListener;
import com.mulesoft.mule.plugin.MulePlugin;
import com.mulesoft.mule.plugin.processor.deployment.DeploymentListenerProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.module.launcher.DeploymentListener;
import org.mule.module.launcher.DeploymentService;
import org.mule.module.launcher.DeploymentServiceAware;
import org.mule.module.launcher.application.Application;

public class AnypointPlugin
implements MulePlugin,
DeploymentListenerProvider,
DeploymentServiceAware,
MuleContextScanner {
    private AnypointClient anypointClient;
    private DeploymentService deploymentService;

    public void setWorkingDirectory(File file) {
    }

    public boolean isDisabledOnEnvironment() {
        return AnypointAgentUtils.isAgentDisabled();
    }

    public void dispose() {
    }

    public void initialise() throws InitialisationException {
        AnypointClientFactory anypointClientFactory = new AnypointClientFactory();
        this.anypointClient = anypointClientFactory.create((MuleContextScanner)this);
    }

    public void start() throws MuleException {
        this.anypointClient.start();
    }

    public void stop() throws MuleException {
        this.anypointClient.stop();
    }

    public DeploymentListener getDeploymentListener() {
        return new AnypointDeploymentListener(this.anypointClient);
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MuleContext> getMuleContexts() {
        if (this.deploymentService == null) {
            return Collections.EMPTY_LIST;
        }
        this.deploymentService.getLock().lock();
        try {
            ArrayList<MuleContext> muleContexts = new ArrayList<MuleContext>();
            for (Application app : this.deploymentService.getApplications()) {
                if (app.getMuleContext() == null) continue;
                muleContexts.add(app.getMuleContext());
            }
            ArrayList<MuleContext> arrayList = muleContexts;
            return arrayList;
        }
        finally {
            this.deploymentService.getLock().unlock();
        }
    }
}

