/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.habitat.plugin.config;

import com.mulesoft.habitat.agent.api.ServiceMetadata;
import org.mule.config.spring.parsers.assembly.BeanAssembler;
import org.mule.config.spring.parsers.generic.MuleOrphanDefinitionParser;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceDefinitionParser
extends MuleOrphanDefinitionParser {
    public ServiceDefinitionParser() {
        super(ServiceMetadata.class, true);
        this.addBeanFlag("org.mule.config.spring.MuleHierarchicalBeanDefinitionParserDelegate.MULE_NO_RECURSE");
    }

    protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        if (element.hasAttribute("id")) {
            builder.addPropertyValue("id", (Object)element.getAttribute("id"));
        }
        if (element.hasAttribute("version")) {
            String[] versionComponents = element.getAttribute("version").split("\\.");
            if (versionComponents.length != 3) {
                throw new IllegalArgumentException("The version of a service must be in X.Y.Z format.");
            }
            builder.addPropertyValue("serviceVersionMajor", (Object)versionComponents[0]);
            builder.addPropertyValue("serviceVersionMinor", (Object)versionComponents[1]);
            builder.addPropertyValue("serviceVersionRevision", (Object)versionComponents[2]);
        }
        builder.addPropertyValue("serviceName", (Object)element.getAttribute("serviceName"));
        builder.addPropertyValue("summary", (Object)element.getAttribute("summary"));
        builder.addPropertyValue("environment", (Object)element.getAttribute("environment"));
        ManagedList tags = new ManagedList();
        ManagedList taxonomies = new ManagedList();
        if (element.hasChildNodes()) {
            for (int i = 0; i < element.getChildNodes().getLength(); ++i) {
                Node node = element.getChildNodes().item(i);
                if (node.getLocalName() == null) continue;
                if (node.getLocalName().equals("tag")) {
                    tags.add((Object)node.getTextContent());
                    continue;
                }
                if (node.getLocalName().equals("taxonomy")) {
                    taxonomies.add((Object)node.getTextContent());
                    continue;
                }
                if (!node.getLocalName().equals("description")) continue;
                builder.addPropertyValue("description", (Object)node.getTextContent());
            }
        }
        builder.addPropertyValue("tags", (Object)tags);
        builder.addPropertyValue("taxonomies", (Object)taxonomies);
        BeanAssembler assembler = this.getBeanAssembler(element, builder);
        this.postProcess(this.getParserContext(), assembler, element);
    }

    protected void assertMuleParent(Element element) {
    }
}

