/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.cluster;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.List;
import mulesoft.cluster.MessageHandler;
import mulesoft.cluster.RpcDispatcher;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.collections.Seq;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ClusterManager<T> {
    public <K> K callRemoteMethod(Class<?> var1, T var2, String var3, Object[] var4, @Nullable Class<?>[] var5, Object var6) throws Exception;

    public <K> K callRemoteMethods(Class<?> var1, List<T> var2, String var3, Object[] var4, @Nullable Class<?>[] var5, Object var6) throws Exception;

    public void deRegisterMessageHandler(int var1);

    public void registerMessageHandler(MessageHandler<?> var1);

    public void registerRpcDispatcher(Class<?> var1, RpcDispatcher var2);

    public void sendMessage(int var1, Serializable var2) throws Exception;

    public void start() throws Exception;

    public void stop();

    public String getClusterName();

    public String getCurrentMember();

    public String getCurrentMemberId();

    public boolean isAlive(@NotNull String var1);

    public T getMaster();

    public T getMember();

    public String getMemberName();

    public String getMemberName(T var1);

    public ImmutableList<T> getMembersAddresses();

    default public Seq<String> getMembersAddressNames() {
        return this.getMembersAddresses().map(a -> a == null ? "NA" : a.toString());
    }

    public String getMemberUUID();

    @Nullable
    public InetAddress getPhysicalAddress(T var1);

    public boolean isMaster();
}

