/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.core;

import java.time.DayOfWeek;
import java.time.format.TextStyle;
import java.util.Locale;
import mulesoft.common.env.context.Context;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Days {
    public static int calendarNumber(DayOfWeek dayOfWeek) {
        switch (dayOfWeek) {
            case MONDAY: {
                return 2;
            }
            case TUESDAY: {
                return 3;
            }
            case WEDNESDAY: {
                return 4;
            }
            case THURSDAY: {
                return 5;
            }
            case FRIDAY: {
                return 6;
            }
            case SATURDAY: {
                return 7;
            }
        }
        return 1;
    }

    public static String cronValue(DayOfWeek day) {
        switch (day) {
            case MONDAY: {
                return "MON";
            }
            case TUESDAY: {
                return "TUE";
            }
            case WEDNESDAY: {
                return "WED";
            }
            case THURSDAY: {
                return "THU";
            }
            case FRIDAY: {
                return "FRI";
            }
            case SATURDAY: {
                return "SAT";
            }
            case SUNDAY: {
                return "SUN";
            }
        }
        return "";
    }

    public static String description(@Nullable DayOfWeek dow) {
        return Days.description(dow, Context.getContext().getLocale());
    }

    public static String description(@Nullable DayOfWeek dow, Locale locale) {
        return dow == null ? "" : dow.getDisplayName(TextStyle.FULL, locale);
    }

    public static DayOfWeek fromCalendarNumber(int dayOfWeek) {
        int dow = dayOfWeek % 7;
        switch (dow) {
            case 1: {
                return DayOfWeek.SUNDAY;
            }
            case 2: {
                return DayOfWeek.MONDAY;
            }
            case 3: {
                return DayOfWeek.TUESDAY;
            }
            case 4: {
                return DayOfWeek.WEDNESDAY;
            }
            case 5: {
                return DayOfWeek.THURSDAY;
            }
            case 6: {
                return DayOfWeek.FRIDAY;
            }
        }
        return DayOfWeek.SATURDAY;
    }

    @Nullable
    public static DayOfWeek fromDescription(@NotNull String description) {
        for (DayOfWeek dayOfWeek : DayOfWeek.values()) {
            if (!Days.description(dayOfWeek).equalsIgnoreCase(description)) continue;
            return dayOfWeek;
        }
        return null;
    }

    public static String shortDescription(@Nullable DayOfWeek dow) {
        return Days.shortDescription(dow, Context.getContext().getLocale());
    }

    public static String shortDescription(@Nullable DayOfWeek dow, Locale locale) {
        return dow == null ? "" : dow.getDisplayName(TextStyle.SHORT, locale);
    }
}

