/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.env;

import javax.inject.Named;
import mulesoft.common.core.Option;
import mulesoft.common.core.Strings;
import mulesoft.common.env.Mutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Environment {
    public void asProduction();

    public void delete(@NotNull String var1, @NotNull Class<?> var2);

    public void delete(@NotNull String var1, @NotNull String var2);

    public void dispose();

    @NotNull
    public <T> T get(@NotNull Class<T> var1);

    @NotNull
    public <T> T get(@NotNull String var1, @NotNull Class<T> var2);

    @NotNull
    public <T> T get(@NotNull Class<T> var1, @Nullable Listener<T> var2);

    @NotNull
    public <T> T get(@NotNull String var1, @NotNull Class<T> var2, @Nullable Listener<T> var3);

    @NotNull
    public <T> T get(@NotNull String var1, @NotNull String var2, @NotNull Class<T> var3, @Nullable Listener<T> var4);

    public <T> void put(@NotNull T var1);

    public <T> void put(@NotNull String var1, @NotNull T var2);

    public <T> void put(@NotNull String var1, @NotNull String var2, @NotNull T var3);

    public boolean isProduction();

    public static class Utils {
        private static final String[] extensions = new String[]{"Props", "Properties", "Config", "Cfg"};

        private Utils() {
        }

        public static boolean immutable(Class<?> clazz) {
            return clazz.getAnnotation(Mutable.class) == null;
        }

        public static String name(Class<?> clazz) {
            String name;
            Named annotation = Utils.getNamed(clazz);
            if (annotation != null && !(name = annotation.value()).isEmpty()) {
                return name;
            }
            String nm = clazz.getSimpleName();
            for (String ext : extensions) {
                if (!nm.endsWith(ext)) continue;
                nm = nm.substring(0, nm.length() - ext.length());
                break;
            }
            return Strings.deCapitalizeFirst((String)nm);
        }

        private static Named getNamed(Class<?> clazz) {
            for (Class<?> currentClazz = clazz; currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
                Named annotation = currentClazz.getAnnotation(Named.class);
                if (annotation == null) continue;
                return annotation;
            }
            return null;
        }
    }

    public static interface Listener<T> {
        public void onChange(@NotNull Option<T> var1);
    }
}

