/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.env;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.Seq;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Version {
    private final Map<String, ComponentInfo> components = new HashMap<String, ComponentInfo>();
    private static final Version INSTANCE = new Version();

    private Version() {
        this.addComponent("Sui Generis", this.getProperty("suigeneris.version"), this.getProperty("suigeneris.build"), this.getProperty("suigeneris.branch"));
    }

    public void addComponent(@NotNull String component, @NotNull String version, @NotNull String build, @NotNull String branch) {
        this.components.put(component, ComponentInfo.create(component, version, build, branch));
    }

    public void addComponentFromStream(@NotNull String component, @Nullable InputStream is) throws IOException {
        Properties p = new Properties();
        p.put("build.version", "");
        p.put("build.number", "");
        p.put("build.branch", "");
        if (is != null) {
            p.load(is);
        }
        this.components.put(component, ComponentInfo.create(component, p.getProperty("build.version"), p.getProperty("build.number"), p.getProperty("build.branch")));
    }

    public void addDefaultComponents() throws IOException {
        String compsList;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream compsIS = classLoader.getResourceAsStream("META-INF/application-components.properties");
        Properties compsProps = new Properties();
        if (compsIS != null) {
            compsProps.load(compsIS);
        }
        if (Predefined.isNotEmpty((String)(compsList = compsProps.getProperty("application-components", "")))) {
            String[] compsFullNames;
            for (String compFullName : compsFullNames = compsList.split(",")) {
                InputStream compIS = classLoader.getResourceAsStream(String.format("META-INF/%s-component.properties", compFullName));
                Properties compProps = new Properties();
                if (compIS != null) {
                    compProps.load(compIS);
                }
                String application = compProps.getProperty("build.application", compFullName);
                String version = compProps.getProperty("build.version", "");
                String number = compProps.getProperty("build.number", "");
                String branch = compProps.getProperty("build.branch", "");
                this.components.put(application, ComponentInfo.create(application, version, number, branch));
            }
        }
    }

    public String toString() {
        return this.getComponents().mkString("{\n", "\n", "\n}");
    }

    @NotNull
    public ComponentInfo getComponent(@NotNull String component) {
        return (ComponentInfo)Predefined.ensureNotNull((Object)this.components.get(component), (String)"Component not found!");
    }

    public Seq<ComponentInfo> getComponents() {
        return Colls.seq(this.components.values());
    }

    private String getProperty(String property) {
        return (String)Predefined.notNull((Object)System.getProperty(property), (Object)"");
    }

    public static Version getInstance() {
        return INSTANCE;
    }

    public static final class ComponentInfo
    implements Serializable {
        @NotNull
        private final String branch;
        @NotNull
        private final String build;
        @NotNull
        private final String component;
        @NotNull
        private final String version;
        private static final long serialVersionUID = -3553520054523201767L;

        private ComponentInfo(@NotNull String component, @NotNull String version, @NotNull String build, @NotNull String branch) {
            this.component = component;
            this.version = version;
            this.build = build;
            this.branch = branch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ComponentInfo)) {
                return false;
            }
            ComponentInfo that = (ComponentInfo)o;
            return this.build.equals(that.build) && this.component.equals(that.component) && this.version.equals(that.version);
        }

        public int hashCode() {
            int result = this.component.hashCode();
            result = 31 * result + this.version.hashCode();
            result = 31 * result + this.build.hashCode();
            return result;
        }

        public String toString() {
            return this.getComponent() + (Predefined.isEmpty((String)this.getBuild()) ? " Dev" : String.format(" %s %s-%s", this.getVersion(), this.getBranch(), this.getBuild()));
        }

        @NotNull
        public String getBranch() {
            return this.branch;
        }

        @NotNull
        public String getBuild() {
            return this.build;
        }

        @NotNull
        public String getComponent() {
            return this.component;
        }

        @NotNull
        public String getVersion() {
            return this.version;
        }

        public static ComponentInfo create(@NotNull String component, @NotNull String version, @NotNull String build, @NotNull String branch) {
            return new ComponentInfo(component, version, build, branch);
        }
    }
}

