/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.env.context;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import mulesoft.common.Predefined;
import mulesoft.common.core.Option;
import mulesoft.common.env.Environment;
import mulesoft.common.env.impl.PropertiesEnvironment;
import mulesoft.common.util.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextImpl {
    private final Map<Class<?>, Class<?>> binding = new HashMap();
    private final ThreadLocal<String> currentFqn;
    private final ThreadLocal<String> host;
    private final ThreadLocal<String> lcid;
    private final ThreadLocal<Locale> locale;
    private final ThreadLocal<String> path;
    private final Map<Class<?>, Object> singleton;
    private final Map<String, Object> variables = new HashMap<String, Object>();

    ContextImpl() {
        this.singleton = new HashMap();
        this.locale = new ThreadLocal();
        this.lcid = new ThreadLocal();
        this.host = new ThreadLocal();
        this.path = new ThreadLocal();
        this.currentFqn = new ThreadLocal();
        this.bind(Environment.class, PropertiesEnvironment.class);
    }

    public <T> void bind(@NotNull Class<T> source, @NotNull Class<? extends T> implementation) {
        this.binding.put(source, implementation);
    }

    public void clean() {
        this.binding.clear();
        this.singleton.clear();
    }

    public boolean hasBinding(@NotNull Class<?> source) {
        return this.binding.containsKey(source);
    }

    public <T> T newInstance(@NotNull Class<T> clazz) {
        Class<?> implementation = this.binding.get(clazz);
        if (implementation == null) {
            throw new RuntimeException("Class '" + clazz.getCanonicalName() + "' not registered.");
        }
        return (T)Predefined.cast((Object)Reflection.construct(implementation, (Object[])new Object[0]));
    }

    public <T> Class<? extends T> unbind(@NotNull Class<T> source) {
        Class implementation = (Class)Predefined.cast(this.binding.remove(source));
        this.singleton.remove(source);
        return implementation;
    }

    public String getCurrentHistoryForm() {
        return this.currentFqn.get();
    }

    public void setCurrentHistoryForm(@NotNull String fqn) {
        this.currentFqn.set(fqn);
    }

    public String getHost() {
        return this.host.get();
    }

    public void setHost(String remoteHost) {
        this.host.set(remoteHost);
    }

    public Option<String> getLifeCycleId() {
        return Predefined.option((Object)this.lcid.get());
    }

    public void setLifeCycleId(@Nullable String id) {
        this.lcid.set(id);
    }

    public Locale getLocale() {
        Locale l = this.locale.get();
        return l == null ? Locale.getDefault() : l;
    }

    public void setLocale(Locale l) {
        this.locale.set(l);
    }

    public String getPath() {
        return Predefined.notEmpty((String)this.path.get(), (String)"/");
    }

    public void setPath(String p) {
        this.path.set(p);
    }

    public <T> T getSingleton(@NotNull Class<T> clazz) {
        T t = clazz.cast(this.singleton.get(clazz));
        return t != null ? t : this.initialize(clazz);
    }

    @Nullable
    public synchronized <T> T setSingleton(@NotNull Class<T> clazz, T value) {
        Object o;
        if (!this.hasBinding(clazz)) {
            Class c = (Class)Predefined.cast(value.getClass());
            this.bind(clazz, c);
        }
        return (o = this.singleton.put(clazz, value)) == null ? null : (T)clazz.cast(o);
    }

    public <T> T getVariable(@NotNull String key) {
        return (T)Predefined.cast((Object)this.variables.get(key));
    }

    public void setVariable(@NotNull String key, @Nullable Object value) {
        this.variables.put(key, value);
    }

    private synchronized <T> T initialize(Class<T> clazz) {
        Object o = this.singleton.get(clazz);
        if (o != null) {
            return (T)Predefined.cast((Object)o);
        }
        T t = this.newInstance(clazz);
        this.singleton.put(clazz, t);
        return t;
    }
}

