/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.env.i18n;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import mulesoft.common.Predefined;
import mulesoft.common.core.Suppliers;
import mulesoft.common.env.context.Context;
import mulesoft.common.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class I18nBundle {
    private final String bundleName;
    @NotNull
    private Supplier<? extends ResourceBundle> bundleRef;
    private ClassLoader classLoader;
    private Locale currentBundleLocale;
    private static final Map<String, I18nBundle> bundleMap = new HashMap<String, I18nBundle>();
    private static final Object LOCK = new Object();
    public static final String GET_METHOD = "getString";
    private static final Logger logger = Logger.getLogger(I18nBundle.class);
    private static final Object[][] NOTHING = new Object[0][];
    private static final Supplier<? extends ResourceBundle> EMPTY_BUNDLE = Suppliers.fromObject((Object)new ListResourceBundle(){

        @Override
        protected Object[][] getContents() {
            return NOTHING;
        }
    });

    private I18nBundle(String bundleName) {
        this.bundleName = bundleName;
        this.bundleRef = Suppliers.empty();
        this.currentBundleLocale = null;
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public boolean containsKey(@NotNull String key, @NotNull Locale locale) {
        return this.getBundle(locale, false).containsKey(key);
    }

    public boolean existsFor(Locale locale) {
        this.getBundle(locale, false);
        return this.bundleRef != EMPTY_BUNDLE;
    }

    public I18nBundle setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
        return this;
    }

    public String getName() {
        return this.bundleName;
    }

    @NotNull
    public String getString(@NotNull String key, @NotNull Locale locale) {
        return Predefined.notNull((String)this.find(String.class, key, null, locale, true));
    }

    @NotNull
    public String getString(@NotNull String key, @NotNull String defaultValue) {
        return this.getString(key, defaultValue, Context.getContext().getLocale());
    }

    @NotNull
    public String getString(@NotNull String key, @NotNull String defaultValue, @NotNull Locale locale) {
        return (String)Predefined.notNull((Object)this.find(String.class, key, defaultValue, locale, false), (Object)defaultValue);
    }

    @Nullable
    private <T> T find(Class<T> clazz, @NotNull String key, @Nullable T defaultValue, @NotNull Locale locale, boolean log) {
        ResourceBundle bundle = this.getBundle(locale, log);
        if (defaultValue != null && !bundle.containsKey(key)) {
            return defaultValue;
        }
        try {
            Object object = bundle.getObject(key);
            if (clazz.isInstance(object)) {
                return (T)Predefined.cast((Object)object);
            }
            this.log(log, "Invalid type for Resource", key);
        }
        catch (MissingResourceException r) {
            this.log(log, "Can't find Resource", key);
        }
        return defaultValue;
    }

    private void log(boolean log, String message, String key) {
        if (log) {
            logger.warning(message + " : " + this.bundleName + (key.isEmpty() ? "" : "." + key));
        }
    }

    private ResourceBundle getBundle(Locale locale, boolean log) {
        ResourceBundle bundle = this.bundleRef.get();
        if (bundle != null && locale.equals(this.currentBundleLocale)) {
            return bundle;
        }
        try {
            bundle = ResourceBundle.getBundle(this.bundleName, locale, this.classLoader);
            SoftReference<ResourceBundle> reference = new SoftReference<ResourceBundle>(bundle);
            this.bundleRef = reference::get;
        }
        catch (MissingResourceException e) {
            this.log(log, "Can't find bundle", "");
            this.bundleRef = EMPTY_BUNDLE;
            bundle = this.bundleRef.get();
        }
        this.currentBundleLocale = locale;
        return (ResourceBundle)Predefined.ensureNotNull((Object)bundle);
    }

    public static I18nBundle getBundle(Class<?> clazz) {
        return I18nBundle.getBundle(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static I18nBundle getBundle(String bundleName) {
        I18nBundle i18nBundle;
        Object object = LOCK;
        synchronized (object) {
            i18nBundle = bundleMap.computeIfAbsent(bundleName, k -> new I18nBundle(bundleName));
        }
        return i18nBundle;
    }
}

