/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.env.i18n;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import java.util.Locale;
import mulesoft.common.core.Option;
import mulesoft.common.env.context.Context;
import mulesoft.common.env.i18n.I18nBundle;
import mulesoft.common.env.i18n.I18nMessages;
import org.jetbrains.annotations.NotNull;

public class I18nMessagesFactory {
    private I18nMessagesFactory() {
    }

    public static <T extends I18nMessages> T create(Class<T> clazz) {
        try {
            Class[] interfaces = new Class[]{clazz};
            return (T)((I18nMessages)clazz.cast(Proxy.newProxyInstance(clazz.getClassLoader(), interfaces, new Handler<T>(clazz, (Option<Locale>)Option.empty()))));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends I18nMessages> T create(@NotNull Class<T> clazz, @NotNull Locale locale) {
        try {
            Class[] interfaces = new Class[]{clazz};
            Handler<T> handler = new Handler<T>(clazz, (Option<Locale>)Option.of((Object)locale));
            ((Handler)handler).bundle.setClassLoader(clazz.getClassLoader());
            return (T)((I18nMessages)clazz.cast(Proxy.newProxyInstance(clazz.getClassLoader(), interfaces, handler)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class Handler<T>
    implements InvocationHandler {
        private final I18nBundle bundle;
        private final Option<Locale> locale;

        public Handler(Class<T> clazz, Option<Locale> locale) {
            this.bundle = I18nBundle.getBundle(clazz);
            this.locale = locale;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String defaultValue = method.getAnnotation(I18nMessages.DefaultMessage.class).value();
            String msg = this.bundle.getString(method.getName(), defaultValue, (Locale)this.locale.orElse((Object)Context.getContext().getLocale()));
            return args == null ? msg : MessageFormat.format(msg, args);
        }
    }
}

