/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.env.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mulesoft.common.Predefined;
import mulesoft.common.core.Option;
import mulesoft.common.env.Environment;
import mulesoft.common.env.jmx.JmxHelper;
import mulesoft.common.env.jmx.JmxPropertiesMBean;
import mulesoft.common.util.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseEnvironment
implements Environment {
    private final Map<String, JmxPropertiesMBean<?>> mBeanMap = new LinkedHashMap();
    private boolean productionEnv = false;
    public static final String LISTENER_FOR_IMMUTABLE_VALUE_MSG = "Listener for immutable value";

    protected BaseEnvironment() {
    }

    @Override
    public void asProduction() {
        this.productionEnv = true;
    }

    @Override
    public void delete(@NotNull String scope, @NotNull Class<?> clazz) {
        this.delete(scope, Environment.Utils.name(clazz));
    }

    @Override
    public synchronized void delete(@NotNull String scope, @NotNull String name) {
        String key = BaseEnvironment.makeKey(scope, name);
        Entry entry = this.getValue(key);
        if (entry != null) {
            if (entry.listeners.isEmpty()) {
                this.remove(key);
            } else {
                entry.nullEntry(key);
            }
        }
    }

    @Override
    public void dispose() {
    }

    public abstract <T> T fetchValue(@NotNull String var1, @NotNull Class<T> var2);

    @Override
    @NotNull
    public final <T> T get(@NotNull Class<T> clazz) {
        return this.get("", clazz);
    }

    @Override
    @NotNull
    public final <T> T get(@NotNull String scope, @NotNull Class<T> clazz) {
        return this.get(scope, "", clazz);
    }

    @Override
    @NotNull
    public final <T> T get(@NotNull Class<T> clazz, Environment.Listener<T> listener) {
        return this.get("", "", clazz, listener);
    }

    @Override
    @NotNull
    public final <T> T get(@NotNull String scope, @NotNull Class<T> clazz, Environment.Listener<T> listener) {
        return this.get(scope, "", clazz, listener);
    }

    @Override
    @NotNull
    public final <T> T get(@NotNull String scope, @NotNull String name, @NotNull Class<T> clazz, @Nullable Environment.Listener<T> listener) {
        if (listener != null && Environment.Utils.immutable(clazz)) {
            throw new IllegalArgumentException(LISTENER_FOR_IMMUTABLE_VALUE_MSG);
        }
        Iterator iterator = this.find(scope, name, clazz, listener).iterator();
        if (iterator.hasNext()) {
            Object t = iterator.next();
            return (T)t;
        }
        Object value = Reflection.construct(clazz, (Object[])new Object[0]);
        this.put("", name, value, false);
        return (T)this.find(scope, name, clazz, listener).getOrFail("Illegal State");
    }

    @Override
    public <T> void put(@NotNull T value) {
        this.put("", value);
    }

    @Override
    public <T> void put(@NotNull String scope, @NotNull T value) {
        this.put(scope, "", value);
    }

    @Override
    public synchronized <T> void put(@NotNull String scope, @NotNull String nm, @NotNull T value) {
        this.put(scope, nm, value, true);
    }

    public abstract void refresh();

    @Override
    public boolean isProduction() {
        return this.productionEnv;
    }

    @Nullable
    protected abstract <T> Entry<T> doGetValue(@NotNull String var1);

    protected abstract void doSetValue(@NotNull String var1, @NotNull Entry<?> var2);

    protected abstract void remove(@NotNull String var1);

    @Nullable
    protected <T> Entry<T> getValue(@NotNull String key) {
        Entry<T> entry = this.doGetValue(key);
        if (entry != null) {
            this.registerJmx(key, entry);
        }
        return entry;
    }

    protected final <T> void setValue(@NotNull String key, @NotNull Entry<T> entry) {
        this.registerJmx(key, entry);
        this.doSetValue(key, entry);
    }

    @NotNull
    private synchronized <T> Option<T> find(@NotNull String scope, @NotNull String nm, @NotNull Class<T> clazz, @Nullable Environment.Listener<T> listener) {
        Entry<T> emptyEntry;
        String name = nm.isEmpty() ? Environment.Utils.name(clazz) : nm;
        String key = BaseEnvironment.makeKey(scope, name);
        Entry<T> e = this.getValue(key);
        if (e != null) {
            Entry<T> entry = e.as(clazz);
            entry.addListener(listener);
            Object value = ((Entry)entry).value;
            return value == null && !scope.isEmpty() ? this.find("", name, clazz, null) : Option.option((Object)value);
        }
        T value = this.fetchValue(key, clazz);
        if (value != null) {
            this.setValue(key, new Entry<T>(name, clazz, value, listener));
            return Option.option(value);
        }
        if (listener == null) {
            emptyEntry = null;
        } else {
            emptyEntry = new Entry<T>(name, clazz, listener);
            this.setValue(key, emptyEntry);
        }
        if (scope.isEmpty()) {
            return Option.empty();
        }
        return this.find("", name, clazz, emptyEntry == null ? null : new ScopedListener<T>(emptyEntry));
    }

    @NotNull
    private <T> T get(@NotNull String scope, @NotNull String name, @NotNull Class<T> clazz) {
        return this.get(scope, name, clazz, null);
    }

    private synchronized <T> void put(@NotNull String scope, @NotNull String nm, @NotNull T value, boolean notify) {
        Class clazz = (Class)Predefined.cast(value.getClass());
        String name = nm.isEmpty() ? Environment.Utils.name(clazz) : nm;
        String key = BaseEnvironment.makeKey(scope, name);
        Entry<T> e = this.getValue(key);
        if (e == null) {
            Entry<T> entry = new Entry<T>(name, clazz, value, null);
            this.setValue(key, entry);
        } else {
            Entry entry = e.as(clazz);
            this.removedScopedListener(scope, name, e);
            entry.setValue(value, notify);
            this.setValue(key, entry);
        }
    }

    private <T> void registerJmx(@NotNull String key, @NotNull Entry<T> entry) {
        if (!this.mBeanMap.containsKey(key)) {
            String scope = BaseEnvironment.extractScope(key);
            JmxPropertiesMBean<T> bean = new JmxPropertiesMBean<T>(scope, entry.getClazz(), entry.getValue(), this);
            this.mBeanMap.put(key, bean);
            JmxHelper.registerMBean(scope, "tekgenesis.configuration", entry.getName(), bean);
        }
    }

    private void removedScopedListener(String scope, String name, Entry<?> entry) {
        Entry e;
        if (((Entry)entry).value == null && !scope.isEmpty() && (e = this.getValue(BaseEnvironment.makeKey("", name))) != null) {
            e.removeScopedListener(entry);
        }
    }

    private static String extractScope(@NotNull String key) {
        assert (!Predefined.isEmpty((String)key));
        int i = key.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return key.substring(0, i);
    }

    private static String makeKey(@NotNull String scope, @NotNull String name) {
        return scope.isEmpty() ? name : scope + "." + name;
    }

    protected static class ScopedListener<T>
    implements Environment.Listener<T> {
        private final Entry<T> entry;

        ScopedListener(Entry<T> e) {
            this.entry = e;
        }

        @Override
        public void onChange(@NotNull Option<T> value) {
            this.entry.fireListeners(value);
        }
    }

    public class Entry<T> {
        @NotNull
        private final Class<T> clazz;
        private final List<Environment.Listener<T>> listeners;
        @NotNull
        private final String name;
        @Nullable
        private T value;

        Entry(@NotNull String name, @Nullable Class<T> clazz, Environment.Listener<T> listener) {
            this(name, clazz, null, listener);
        }

        public Entry(@NotNull String name, @Nullable Class<T> clazz, @Nullable T value, Environment.Listener<T> listener) {
            this.name = name;
            this.clazz = clazz;
            this.value = value;
            this.listeners = new ArrayList<Environment.Listener<T>>(1);
            this.addListener(listener);
        }

        public void removeScopedListener(Entry<?> scopedEntry) {
            this.listeners.removeIf(l -> l instanceof ScopedListener && ((ScopedListener)l).entry == scopedEntry);
        }

        @NotNull
        public Class<T> getClazz() {
            return this.clazz;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @Nullable
        public T getValue() {
            return this.value;
        }

        public void setValue(@NotNull T value) {
            this.setValue(value, true);
        }

        void addListener(@Nullable Environment.Listener<T> listener) {
            if (listener != null) {
                this.listeners.add(listener);
            }
        }

        <E> Entry<E> as(Class<E> c) {
            if (!c.isAssignableFrom(this.clazz)) {
                throw new IllegalArgumentException(c.getName() + " must be assignable from " + this.clazz.getName());
            }
            return (Entry)Predefined.cast((Object)this);
        }

        void fireListeners(@NotNull Option<T> v) {
            for (Environment.Listener<T> listener : this.listeners) {
                listener.onChange(v);
            }
        }

        void nullEntry(String key) {
            if (this.listeners.isEmpty()) {
                return;
            }
            if (this.value == null) {
                return;
            }
            this.value = null;
            boolean noScope = key.equals(this.name);
            this.fireListeners(noScope ? Option.empty() : BaseEnvironment.this.find("", this.name, this.clazz, new ScopedListener(this)));
        }

        void setValue(@NotNull T v, boolean notify) {
            this.value = v;
            if (notify) {
                this.fireListeners(Option.option(v));
            }
        }
    }
}

