/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.env.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import mulesoft.common.Predefined;
import mulesoft.common.env.impl.BaseEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryEnvironment
extends BaseEnvironment {
    private final Map<String, BaseEnvironment.Entry<?>> values;

    public MemoryEnvironment() {
        this(null);
    }

    public MemoryEnvironment(MemoryEnvironment env) {
        this.values = env == null ? new LinkedHashMap() : env.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Map<String, BaseEnvironment.Entry<?>> map = this.values;
        synchronized (map) {
            this.values.clear();
        }
    }

    @Override
    public <T> T fetchValue(@NotNull String key, @NotNull Class<T> clazz) {
        return null;
    }

    @Override
    public void refresh() {
        for (Map.Entry<String, BaseEnvironment.Entry<?>> e : this.values.entrySet()) {
            BaseEnvironment.Entry entry = (BaseEnvironment.Entry)Predefined.cast(e.getValue());
            String key = e.getKey();
            Object value = this.fetchValue(key, entry.getClazz());
            if (value != null) {
                entry.setValue(value);
                continue;
            }
            entry.nullEntry(key);
        }
    }

    @Override
    @Nullable
    protected <T> BaseEnvironment.Entry<T> doGetValue(@NotNull String key) {
        return (BaseEnvironment.Entry)Predefined.cast(this.values.get(key));
    }

    @Override
    protected void doSetValue(@NotNull String key, @NotNull BaseEnvironment.Entry<?> entry) {
        this.values.put(key, entry);
    }

    @Override
    protected void remove(@NotNull String key) {
        this.values.remove(key);
    }
}

