/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.env.impl;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import mulesoft.common.env.Properties;
import mulesoft.common.env.i18n.CommonMessages;
import mulesoft.common.env.impl.MemoryEnvironment;
import mulesoft.common.logging.Logger;
import mulesoft.common.util.Conversions;
import mulesoft.common.util.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesEnvironment
extends MemoryEnvironment {
    @Nullable
    private final File file;
    private final SortedMap<String, String> properties;
    private static final String DEFAULT_CONFIG_FILE = "hermes.properties";
    private static final Logger logger = Logger.getLogger(PropertiesEnvironment.class);

    public PropertiesEnvironment() {
        this(PropertiesEnvironment.getPropertiesFile());
    }

    public PropertiesEnvironment(MemoryEnvironment mem) {
        this(null, mem);
    }

    public PropertiesEnvironment(@Nullable File propFile) {
        this(propFile, null);
    }

    private PropertiesEnvironment(@Nullable File propFile, @Nullable MemoryEnvironment env) {
        super(env);
        this.file = propFile;
        this.properties = new TreeMap<String, String>();
        this.loadProperties(propFile);
        this.loadProperties(System.getProperties());
    }

    @Override
    public <T> T fetchValue(@NotNull String key, @NotNull Class<T> clazz) {
        if (Conversions.isConvertible(clazz)) {
            return (T)Conversions.fromString((String)((String)this.properties.get(key)), clazz);
        }
        Map<String, String> m = this.subMap(this.properties, key);
        return m.isEmpty() ? null : (T)this.buildObject(clazz, m, key + ".");
    }

    @Override
    public void refresh() {
        this.loadProperties(this.file);
        this.loadProperties(System.getProperties());
        super.refresh();
    }

    private <T> T buildObject(Class<T> clazz, Map<String, String> map, String prefix) {
        Object result = Reflection.construct(clazz, (Object[])new Object[0]);
        Class<T> currentClazz = clazz;
        while (currentClazz != null) {
            for (Field field : currentClazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                String fieldName = field.getName();
                String value = map.get(prefix + fieldName);
                if (value == null) {
                    logger.debug(CommonMessages.COMMON_MSGS.fieldNotFound(fieldName));
                    continue;
                }
                Reflection.setFieldValue((Object)result, (Field)field, (Object)Conversions.fromString((String)value, field.getType()));
            }
            if (Properties.class.isAssignableFrom(currentClazz = currentClazz.getSuperclass())) continue;
            currentClazz = null;
        }
        return (T)result;
    }

    private void loadProperties(File propFile) {
        try {
            if (propFile != null && propFile.exists()) {
                java.util.Properties p = new java.util.Properties();
                p.load(new FileReader(propFile));
                this.loadProperties(p);
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    private void loadProperties(java.util.Properties ps) {
        for (Map.Entry<Object, Object> e : ps.entrySet()) {
            Object key = e.getKey();
            Object value = e.getValue();
            if (key instanceof String) {
                if (value instanceof String) {
                    this.properties.put((String)key, (String)value);
                    continue;
                }
                logger.warning(String.format("Properties value %s for key %s is not a String (%s)", value.toString(), key, value.getClass().getName()));
                continue;
            }
            logger.warning(String.format("Properties key %s is not a String (%s)", key.toString(), key.getClass().getName()));
        }
    }

    private Map<String, String> subMap(SortedMap<String, String> map, String path) {
        return map.subMap(path, path + "/");
    }

    private static File getPropertiesFile() {
        return new File(System.getProperty(DEFAULT_CONFIG_FILE, DEFAULT_CONFIG_FILE));
    }
}

