/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.env.jmx;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import mulesoft.common.Predefined;
import mulesoft.common.logging.Logger;
import org.jetbrains.annotations.NotNull;

public class JmxHelper {
    public static final String CLUSTER_DOMAIN = "tekgenesis.cluster";
    private static final Logger logger = Logger.getLogger(JmxHelper.class);

    private JmxHelper() {
    }

    public static ObjectName createObjectName(@NotNull String resourceName, @NotNull String domain, @NotNull String type) throws MalformedObjectNameException {
        String name = Predefined.isEmpty((String)resourceName) ? "default" : resourceName;
        return new ObjectName(domain + ":Name=" + name + ",type=" + type);
    }

    public static void registerMBean(@NotNull String resourceName, @NotNull String domain, @NotNull String type, @NotNull Object object) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        JmxHelper.registerMBean(mbs, resourceName, domain, type, object);
    }

    public static void registerMBean(MBeanServer mbs, @NotNull String resourceName, @NotNull String domain, @NotNull String type, @NotNull Object object) {
        if (mbs != null) {
            try {
                ObjectName objectName = JmxHelper.createObjectName(resourceName, domain, type);
                if (!JmxHelper.isRegistered(objectName)) {
                    mbs.registerMBean(object, objectName);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        } else {
            logger.error("Unable to obtain the PlatformMBeanserver");
        }
    }

    public static void unregisterMBean(@NotNull String resourceName, @NotNull String domain, @NotNull String type) {
        try {
            ObjectName objectName = JmxHelper.createObjectName(resourceName, domain, type);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            if (JmxHelper.isRegistered(objectName)) {
                mbs.unregisterMBean(objectName);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public static boolean isRegistered(@NotNull ObjectName objectName) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        return mbs.isRegistered(objectName);
    }
}

