/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.env.jmx;

import ch.qos.logback.classic.Level;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import mulesoft.common.Predefined;
import mulesoft.common.env.Environment;
import mulesoft.common.env.impl.BaseEnvironment;
import mulesoft.common.logging.Logger;
import mulesoft.common.util.Conversions;
import mulesoft.common.util.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JmxPropertiesMBean<T>
implements DynamicMBean {
    private final Class<T> clazz;
    private T defaultValue = null;
    private final BaseEnvironment environment;
    private final String scope;
    private T valueEnv;
    private T valueTemp = null;
    private static final Logger logger = Logger.getLogger(JmxPropertiesMBean.class);

    public JmxPropertiesMBean(@NotNull String scope, @NotNull Class<T> clazz, @Nullable T value, @NotNull BaseEnvironment environment) {
        this.scope = scope;
        this.clazz = clazz;
        this.valueEnv = value;
        this.environment = environment;
    }

    public boolean apply() {
        if (this.valueTemp != null) {
            this.environment.put(this.scope, this.valueTemp);
            this.valueTemp = null;
            this.valueEnv = this.environment.get(this.scope, this.clazz);
            return true;
        }
        return false;
    }

    public void cancel() {
        this.valueTemp = null;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return Reflection.invoke((Object)this, (String)actionName, (Object[])params);
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        T val = this.valueTemp != null ? this.valueTemp : (this.valueEnv != null ? this.valueEnv : this.getDefaultValue());
        return Predefined.ensureNotNull((Object)Reflection.getPrivateField(val, (String)attribute)).toString();
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.setFieldValue(attribute, this.getTempValue());
    }

    @Override
    public final AttributeList getAttributes(String[] attributes) {
        AttributeList result = new AttributeList(attributes.length);
        for (String attrName : attributes) {
            try {
                Object attrValue = this.getAttribute(attrName);
                result.add(new Attribute(attrName, attrValue));
            }
            catch (Exception e) {
                logger.warning((Throwable)e);
            }
        }
        return result;
    }

    @Override
    public final AttributeList setAttributes(AttributeList attributes) {
        AttributeList result = new AttributeList(attributes.size());
        for (Object attrObj : attributes) {
            Attribute attr = (Attribute)attrObj;
            try {
                this.setAttribute(attr);
                result.add(new Attribute(attr.getName(), attr.getValue()));
            }
            catch (Exception e) {
                logger.warning((Throwable)e);
            }
        }
        return result;
    }

    @Override
    public synchronized MBeanInfo getMBeanInfo() {
        boolean mutable = !Environment.Utils.immutable(this.clazz);
        Set fields = Reflection.getPublicFields(this.clazz);
        MBeanAttributeInfo[] attrs = new MBeanAttributeInfo[fields.size()];
        Iterator iterator = fields.iterator();
        for (int i = 0; i < attrs.length; ++i) {
            Field field = (Field)iterator.next();
            String name = field.getName();
            Class<Object> type = field.getType();
            if (!type.isPrimitive()) {
                type = String.class;
            }
            attrs[i] = new MBeanAttributeInfo(name, type.getName(), "Property " + name, true, mutable, false);
        }
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{new MBeanOperationInfo("apply", "Applies the changes into the environment", null, Boolean.class.getName(), 1), new MBeanOperationInfo("cancel", "Cancels all changes", null, null, 1)};
        return new MBeanInfo(this.getClass().getName(), "Property Manager MBean", attrs, null, operations, null);
    }

    private T getDefaultValue() {
        if (this.defaultValue == null) {
            this.defaultValue = this.environment.get("", this.clazz);
        }
        return this.defaultValue;
    }

    private void setFieldValue(Attribute attribute, Object entryValue) throws ReflectionException {
        try {
            Field field = entryValue.getClass().getField(attribute.getName());
            Object value = attribute.getValue();
            Class<?> type = field.getType();
            if (type.equals(Level.class)) {
                Level currentValue = (Level)Reflection.getFieldValue((Object)entryValue, (Field)field);
                value = Level.toLevel((String)((String)value), (Level)currentValue);
            } else {
                value = Conversions.fromString((String)((String)value), type);
            }
            Reflection.setFieldValue((Object)entryValue, (Field)field, (Object)value);
        }
        catch (NoSuchFieldException e) {
            throw new ReflectionException(e);
        }
    }

    private T getTempValue() {
        if (this.valueTemp == null) {
            this.valueTemp = Reflection.construct(this.clazz, (Object[])new Object[0]);
            Reflection.copyDeclaredFields(this.valueEnv != null ? this.valueEnv : this.getDefaultValue(), this.valueTemp);
        }
        return this.valueTemp;
    }
}

