/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.env.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.jmx.JMXConfigurator;
import ch.qos.logback.classic.jmx.MBeanUtil;
import ch.qos.logback.classic.log4j.XMLLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import me.moocar.logbackgelf.GelfAppender;
import mulesoft.common.core.Option;
import mulesoft.common.env.Environment;
import mulesoft.common.env.properties.LoggingProps;
import org.jetbrains.annotations.NotNull;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class LogConfig {
    private LoggerContext context = null;
    private String fullLogFileNamePattern = null;
    private boolean initialized = false;
    private final Map<String, LoggingProps.LoggerProps> loggerPropsMap = new HashMap<String, LoggingProps.LoggerProps>();
    private LoggingProps props;
    private final Set<SizeAndTimeBasedFNATP<ILoggingEvent>> sizeAndTimeBasedFNATPs = new HashSet<SizeAndTimeBasedFNATP<ILoggingEvent>>();
    private final Set<TimeBasedRollingPolicy<ILoggingEvent>> timeBasedRollingPolicies = new HashSet<TimeBasedRollingPolicy<ILoggingEvent>>();
    public static final String CONSOLE = "CONSOLE";
    private static final String PRODUCT_VERSION = "productVersion";
    private static final String[] MDC_KEYS = new String[]{"productVersion", "user", "req.remoteHost", "req.method", "req.requestURL", "req.requestURI", "req.xForwardedFor", "req.queryString", "req.userAgent", "lifecycle.key", "req.uuid"};
    private static final LogConfig ourInstance = new LogConfig();
    private static final String PATTERN_BASE = "%date{ISO8601} %-5level [%thread][%mdc][%class{16}] - %msg%n";

    private LogConfig() {
        this.props = mulesoft.common.env.context.Context.getEnvironment().get(LoggingProps.class, new LoggingPropsListener());
    }

    public LoggingProps getProps() {
        return this.props;
    }

    private void addAppender() {
        this.timeBasedRollingPolicies.clear();
        this.sizeAndTimeBasedFNATPs.clear();
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        if (this.props.consoleOutput) {
            root.addAppender(this.buildConsoleAppender());
        }
        if (this.props.fileOutput) {
            root.addAppender(this.buildFileAppender());
        }
        if (this.props.xmlOutput) {
            root.addAppender(this.buildXmlAppender());
        }
        if (this.props.gelfOutput) {
            root.addAppender((Appender)this.createGelfAppender());
        }
    }

    private ConsoleAppender<ILoggingEvent> buildConsoleAppender() {
        ConsoleAppender consoleAppender = new ConsoleAppender();
        consoleAppender.setName(CONSOLE);
        consoleAppender.setContext((Context)this.context);
        consoleAppender.setWithJansi(true);
        consoleAppender.setEncoder((Encoder)this.patternLayout());
        consoleAppender.start();
        return consoleAppender;
    }

    private RollingFileAppender<ILoggingEvent> buildFileAppender() {
        RollingFileAppender fileAppender = new RollingFileAppender();
        fileAppender.setName("FILE");
        fileAppender.setContext((Context)this.context);
        fileAppender.setFile(this.fullLogFileNamePattern + ".log");
        fileAppender.setEncoder((Encoder)this.patternLayout());
        TimeBasedRollingPolicy rollingPolicy = new TimeBasedRollingPolicy();
        rollingPolicy.setContext((Context)this.context);
        rollingPolicy.setFileNamePattern(this.fullLogFileNamePattern + ".%d.%i.log");
        rollingPolicy.setMaxHistory(this.props.maxDays);
        rollingPolicy.setParent((FileAppender)fileAppender);
        this.timeBasedRollingPolicies.add((TimeBasedRollingPolicy<ILoggingEvent>)rollingPolicy);
        fileAppender.setRollingPolicy((RollingPolicy)rollingPolicy);
        SizeAndTimeBasedFNATP<ILoggingEvent> sizeAndTimeBasedFNATP = this.createSizeAndTimeBasedFNATP((TimeBasedRollingPolicy<ILoggingEvent>)rollingPolicy);
        rollingPolicy.start();
        fileAppender.start();
        sizeAndTimeBasedFNATP.start();
        return fileAppender;
    }

    private Map<String, String> buildGelfMDCMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : MDC_KEYS) {
            result.put(key, "_" + key);
        }
        return result;
    }

    @NotNull
    private RollingFileAppender<ILoggingEvent> buildXmlAppender() {
        RollingFileAppender fileAppenderXml = new RollingFileAppender();
        fileAppenderXml.setName("XML");
        fileAppenderXml.setContext((Context)this.context);
        fileAppenderXml.setFile(this.fullLogFileNamePattern + ".xml");
        TimeBasedRollingPolicy rollingPolicyXml = new TimeBasedRollingPolicy();
        rollingPolicyXml.setContext((Context)this.context);
        rollingPolicyXml.setFileNamePattern(this.fullLogFileNamePattern + "%i.%d.xml");
        rollingPolicyXml.setMaxHistory(this.props.maxDays);
        rollingPolicyXml.setParent((FileAppender)fileAppenderXml);
        this.timeBasedRollingPolicies.add((TimeBasedRollingPolicy<ILoggingEvent>)rollingPolicyXml);
        SizeAndTimeBasedFNATP<ILoggingEvent> sizeAndTimeBasedFNATPXml = this.createSizeAndTimeBasedFNATP((TimeBasedRollingPolicy<ILoggingEvent>)rollingPolicyXml);
        fileAppenderXml.setRollingPolicy((RollingPolicy)rollingPolicyXml);
        LayoutWrappingEncoder layoutWrappingEncoder = new LayoutWrappingEncoder();
        layoutWrappingEncoder.setContext((Context)this.context);
        XMLLayout xmlLayout = new XMLLayout();
        xmlLayout.setContext((Context)this.context);
        xmlLayout.setLocationInfo(true);
        xmlLayout.setProperties(true);
        layoutWrappingEncoder.setLayout((Layout)xmlLayout);
        fileAppenderXml.setEncoder((Encoder)layoutWrappingEncoder);
        fileAppenderXml.start();
        rollingPolicyXml.start();
        sizeAndTimeBasedFNATPXml.start();
        layoutWrappingEncoder.start();
        xmlLayout.start();
        return fileAppenderXml;
    }

    private void configureJmx(@NotNull LoggerContext ctx) {
        if (this.props.jmxEnabled) {
            String contextName = ctx.getName();
            String objectNameAsStr = MBeanUtil.getObjectNameFor((String)contextName, JMXConfigurator.class);
            ObjectName jmxBeanName = MBeanUtil.string2ObjectName((Context)ctx, (Object)this, (String)objectNameAsStr);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            if (!MBeanUtil.isRegistered((MBeanServer)mbs, (ObjectName)jmxBeanName)) {
                JMXConfigurator jmxConfigurator = new JMXConfigurator(ctx, mbs, jmxBeanName);
                try {
                    mbs.registerMBean(jmxConfigurator, jmxBeanName);
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    private void configureLoggers() {
        if (this.initialized) {
            ((Logger)LoggerFactory.getLogger((String)"ROOT")).setLevel(this.props.rootLoggerLevel);
            this.configurePredefinedLoggers();
            this.configurePluggableLoggers();
        }
    }

    private void configurePluggableLoggers() {
        String[] loggerList;
        for (String logger : loggerList = this.props.loggers.split(",")) {
            Level level = this.getLoggerProps((String)logger).level;
            if (level == null) continue;
            ((Logger)LoggerFactory.getLogger((String)logger)).setLevel(level);
        }
    }

    private void configurePredefinedLoggers() {
        boolean debugTekgenesis = this.props.debugAll || this.props.debugTekgenesis;
        ((Logger)LoggerFactory.getLogger((String)"tekgenesis")).setLevel(debugTekgenesis ? Level.DEBUG : this.props.rootLoggerLevel);
    }

    @NotNull
    private GelfAppender createGelfAppender() {
        GelfAppender appender = new GelfAppender();
        appender.setContext((Context)this.context);
        appender.setGraylog2ServerHost(this.props.gelfServer);
        if (this.props.gelfServerPort > 0) {
            appender.setGraylog2ServerPort(this.props.gelfServerPort);
        }
        appender.setUseLoggerName(true);
        appender.setUseThreadName(true);
        appender.setFacility(this.props.gelfFacility);
        appender.setAdditionalFields(this.buildGelfMDCMap());
        appender.setChunkThreshold(2000);
        appender.setGraylog2ServerVersion("0.9.6");
        appender.start();
        return appender;
    }

    private SizeAndTimeBasedFNATP<ILoggingEvent> createSizeAndTimeBasedFNATP(TimeBasedRollingPolicy<ILoggingEvent> rollingPolicy) {
        SizeAndTimeBasedFNATP sizeAndTimeBasedFNATP = new SizeAndTimeBasedFNATP();
        sizeAndTimeBasedFNATP.setContext((Context)this.context);
        sizeAndTimeBasedFNATP.setMaxFileSize(this.props.maxFileSize);
        sizeAndTimeBasedFNATP.setTimeBasedRollingPolicy(rollingPolicy);
        rollingPolicy.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)sizeAndTimeBasedFNATP);
        this.sizeAndTimeBasedFNATPs.add((SizeAndTimeBasedFNATP<ILoggingEvent>)sizeAndTimeBasedFNATP);
        return sizeAndTimeBasedFNATP;
    }

    private void init() {
        if (!this.initialized) {
            ILoggerFactory factory;
            int MAX_RETRIES = 10;
            int WAIT_TIME = 100;
            int i = 0;
            do {
                factory = LoggerFactory.getILoggerFactory();
                ++i;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!(factory instanceof LoggerContext) && i <= 10);
            if (factory instanceof LoggerContext) {
                this.initialized = true;
                this.context = (LoggerContext)factory;
                String dir = this.props.logDir;
                assert (dir != null);
                String logDir = dir.endsWith(File.separator) ? dir : dir + File.separator;
                this.fullLogFileNamePattern = logDir + this.props.logFileName;
                this.context.stop();
                this.context.reset();
                this.context.setName(this.props.contextName);
                MDC.put((String)PRODUCT_VERSION, (String)System.getProperty("product.version", "DEVEL"));
                this.addAppender();
                LogConfig.bridgeJul();
                this.configureLoggers();
                this.context.addListener(new LoggerContextListener(){

                    public boolean isResetResistant() {
                        return true;
                    }

                    public void onStart(LoggerContext ctx) {
                    }

                    public void onReset(LoggerContext ctx) {
                        LogConfig.this.reconfigureAll(true);
                    }

                    public void onStop(LoggerContext ctx) {
                    }

                    public void onLevelChange(Logger logger, Level level) {
                    }
                });
                this.configureJmx(this.context);
            }
        }
    }

    private PatternLayoutEncoder patternLayout() {
        PatternLayoutEncoder patternLayoutEncoderFile = new PatternLayoutEncoder();
        patternLayoutEncoderFile.setPattern(PATTERN_BASE);
        patternLayoutEncoderFile.setOutputPatternAsHeader(false);
        patternLayoutEncoderFile.setContext((Context)this.context);
        patternLayoutEncoderFile.start();
        return patternLayoutEncoderFile;
    }

    private void reconfigureAll(boolean inReset) {
        if (!inReset) {
            this.context.stop();
            this.context.reset();
        }
        this.addAppender();
        LogConfig.bridgeJul();
        this.configureLoggers();
        if (!inReset) {
            this.context.start();
        }
    }

    private LoggingProps.LoggerProps getLoggerProps(@NotNull String loggerName) {
        return this.loggerPropsMap.computeIfAbsent(loggerName, k -> mulesoft.common.env.context.Context.getEnvironment().get(loggerName, LoggingProps.LoggerProps.class, new LoggerPropsListener()));
    }

    public static void bridgeJul() {
        Handler[] handlers;
        java.util.logging.Logger rootLogger = LogManager.getLogManager().getLogger("");
        for (Handler handler : handlers = rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
        SLF4JBridgeHandler.install();
    }

    public static void reconfigure() {
        LogConfig.getInstance().reconfigureAll(false);
    }

    public static void reconfigureLoggers() {
        LogConfig.getInstance().configureLoggers();
    }

    public static void start() {
        LoggerContext loggerContext;
        if (!LogConfig.getInstance().initialized) {
            LogConfig.getInstance().init();
        }
        if ((loggerContext = LogConfig.ourInstance.context) != null && !loggerContext.isStarted()) {
            loggerContext.start();
        }
    }

    public static void stop() {
        if (LogConfig.getInstance().initialized && LogConfig.getInstance().context.isStarted()) {
            LogConfig.getInstance().context.stop();
        }
    }

    public static LogConfig getInstance() {
        return ourInstance;
    }

    private class LoggingPropsListener
    implements Environment.Listener<LoggingProps> {
        private LoggingPropsListener() {
        }

        @Override
        public void onChange(@NotNull Option<LoggingProps> value) {
            if (value.isPresent()) {
                LogConfig.this.props = (LoggingProps)value.get();
                for (TimeBasedRollingPolicy policy : LogConfig.this.timeBasedRollingPolicies) {
                    policy.stop();
                    policy.setMaxHistory(((LoggingProps)value.get()).maxDays);
                    policy.start();
                }
                for (SizeAndTimeBasedFNATP f : LogConfig.this.sizeAndTimeBasedFNATPs) {
                    f.stop();
                    f.setMaxFileSize(((LoggingProps)value.get()).maxFileSize);
                    f.start();
                }
                LogConfig.this.configurePredefinedLoggers();
            }
        }
    }

    private class LoggerPropsListener
    implements Environment.Listener<LoggingProps.LoggerProps> {
        private LoggerPropsListener() {
        }

        @Override
        public void onChange(@NotNull Option<LoggingProps.LoggerProps> value) {
            if (value.isPresent()) {
                LogConfig.this.configurePluggableLoggers();
            }
        }
    }
}

