/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.media;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import mulesoft.common.Predefined;
import mulesoft.common.collections.Maps;
import mulesoft.common.core.Strings;
import mulesoft.common.core.Tuple;
import mulesoft.common.media.MediaTypes;
import mulesoft.common.media.Mime;
import mulesoft.common.media.MimeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MediaType
implements MimeType {
    private final Mime mime;
    private final Map<String, String> parameters;
    public static final MediaType ALL = MediaType.forMime(Mime.ALL);
    public static final MediaType TEXT_XML = MediaType.forMime(Mime.TEXT_XML);
    public static final MediaType TEXT_PLAIN = MediaType.forMime(Mime.TEXT_PLAIN);
    public static final MediaType TEXT_HTML = MediaType.forMime(Mime.TEXT_HTML);
    public static final MediaType TEXT_EVENT_STREAM = MediaType.forMimeWithEncoding(Mime.TEXT_EVENT_STREAM, "UTF-8");
    public static final MediaType APPLICATION_XML = MediaType.forMimeWithEncoding(Mime.APPLICATION_XML, "UTF-8");
    public static final MediaType APPLICATION_JSON = MediaType.forMimeWithEncoding(Mime.APPLICATION_JSON, "UTF-8");
    public static final MediaType APPLICATION_JAVASCRIPT = MediaType.forMimeWithEncoding(Mime.APPLICATION_JAVASCRIPT, "UTF-8");
    public static final MediaType APPLICATION_OCTET_STREAM = MediaType.forMime(Mime.APPLICATION_OCTET_STREAM);
    public static final MediaType APPLICATION_FORM_URLENCODED = MediaType.forMime(Mime.APPLICATION_FORM_URLENCODED);
    public static final String CHARSET_PARAMETER = "charset";

    public MediaType(@NotNull Mime mime) {
        this(mime, Collections.emptyMap());
    }

    public MediaType(@NotNull Mime mime, @NotNull Map<String, String> parameters) {
        this.mime = mime;
        this.parameters = parameters;
    }

    public MediaType(@NotNull Mime mime, @NotNull Tuple<String, String> parameter) {
        this.mime = mime;
        this.parameters = Maps.hashMap(parameter, (Tuple[])new Tuple[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaType other = (MediaType)o;
        if (this.mime != other.mime) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            String v = other.parameters.get(entry.getKey());
            if (Predefined.equal((Object)entry.getValue(), (Object)v)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.mime.hashCode();
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            result = 31 * result + entry.getKey().hashCode() + entry.getValue().hashCode();
        }
        return result;
    }

    public boolean includes(MediaType mediaType) {
        return MediaTypes.includes(this, mediaType);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.appendTo(builder);
        return builder.toString();
    }

    @Nullable
    public Charset getCharset() {
        String charset = this.getParameter(CHARSET_PARAMETER);
        return charset != null ? Charset.forName(Strings.unquote((String)charset)) : null;
    }

    @NotNull
    public Mime getMime() {
        return this.mime;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    @NotNull
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @NotNull
    public String getSubtype() {
        return this.mime.getSubtype();
    }

    @NotNull
    public String getType() {
        return this.mime.getType();
    }

    protected void appendTo(StringBuilder builder) {
        builder.append(this.mime.getMime());
        this.appendTo(this.parameters, builder);
    }

    private void appendTo(@NotNull Map<String, String> map, StringBuilder builder) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.append(';');
            builder.append(entry.getKey());
            builder.append('=');
            builder.append(entry.getValue());
        }
    }

    public static MediaType forMime(@NotNull Mime mime) {
        return new MediaType(mime);
    }

    public static MediaType forMimeWithEncoding(@NotNull Mime mime, @NotNull String encoding) {
        return new MediaType(mime, (Tuple<String, String>)Tuple.tuple((Object)CHARSET_PARAMETER, (Object)encoding));
    }

    public static MediaType fromString(@NotNull String mediaType) {
        return MediaTypes.parseMediaType(mediaType);
    }
}

