/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.media;

import java.nio.charset.UnsupportedCharsetException;
import java.util.LinkedHashMap;
import mulesoft.common.Predefined;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.core.Strings;
import mulesoft.common.media.InvalidMediaTypeException;
import mulesoft.common.media.MediaType;
import mulesoft.common.media.Mime;
import mulesoft.common.media.MimeType;

class MediaTypes {
    private MediaTypes() {
    }

    public static boolean includes(MimeType base, MimeType other) {
        if (other == null) {
            return false;
        }
        if (base.getType().equals("*")) {
            return true;
        }
        if (base.getType().equals(other.getType())) {
            if (base.getSubtype().equals(other.getSubtype())) {
                return true;
            }
            if (base.getSubtype().equals("*")) {
                int basePlus = base.getSubtype().indexOf(43);
                if (basePlus == -1) {
                    return true;
                }
                int otherPlus = other.getSubtype().indexOf(43);
                if (otherPlus != -1) {
                    String otherSubtypeSuffix;
                    String baseSubtypeNoSuffix = base.getSubtype().substring(0, basePlus);
                    String baseSubtypeSuffix = base.getSubtype().substring(basePlus + 1);
                    if (baseSubtypeSuffix.equals(otherSubtypeSuffix = other.getSubtype().substring(otherPlus + 1)) && "*".equals(baseSubtypeNoSuffix)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    static MediaType parseMediaType(String mime) {
        int subIndex;
        if (Predefined.isEmpty((String)mime)) {
            throw MediaTypes.error(mime, "'mime' must not be empty");
        }
        ImmutableList parts = Strings.split((String)mime, (char)';');
        String fullType = ((String)parts.get(0)).trim();
        if ("*".equals(fullType)) {
            fullType = Mime.ALL.getMime();
        }
        if ((subIndex = fullType.indexOf(47)) == -1) {
            throw MediaTypes.error(mime, "does not contain '/'");
        }
        if (subIndex == fullType.length() - 1) {
            throw MediaTypes.error(mime, "does not contain subtype after '/'");
        }
        String type = fullType.substring(0, subIndex);
        String subtype = fullType.substring(subIndex + 1, fullType.length());
        if ("*".equals(type) && !"*".equals(subtype)) {
            throw MediaTypes.error(mime, "wildcard type is legal only in '*/*' (all mime types)");
        }
        LinkedHashMap<String, String> parameters = null;
        if (parts.size() > 1) {
            parameters = new LinkedHashMap<String, String>(parts.size() - 1);
            for (int i = 1; i < parts.size(); ++i) {
                String param = (String)parts.get(i);
                int eq = param.indexOf(61);
                if (eq == -1) continue;
                parameters.put(param.substring(0, eq), param.substring(eq + 1, param.length()));
            }
        }
        try {
            Mime m = Mime.fromMimeString((String)(type + "/" + subtype));
            if (m == null) {
                throw MediaTypes.error(mime, "undefined Mime for '" + type + "/" + subtype + "'");
            }
            return parameters != null ? new MediaType(m, parameters) : new MediaType(m);
        }
        catch (UnsupportedCharsetException ex) {
            throw MediaTypes.error(mime, "unsupported charset '" + ex.getCharsetName() + "'");
        }
        catch (IllegalArgumentException ex) {
            throw MediaTypes.error(mime, ex.getMessage());
        }
    }

    private static InvalidMediaTypeException error(String mime, String message) {
        return new InvalidMediaTypeException(mime, message);
    }
}

