/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.service;

import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.MultiMap;
import mulesoft.common.collections.Seq;
import mulesoft.common.core.DateTime;
import mulesoft.common.core.Option;
import mulesoft.common.core.Strings;
import mulesoft.common.logging.Logger;
import mulesoft.common.media.InvalidMediaTypeException;
import mulesoft.common.media.MediaType;
import mulesoft.common.service.HeaderNames;
import mulesoft.common.service.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Headers
implements HeaderNames {
    private final MultiMap<String, String> map = new MultiMap.Builder().withSortedKeys(String::compareToIgnoreCase).withUniqueValues().build();
    private static final DateFormat DATE_HEADER_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
    private static final Logger logger = Logger.getLogger(Headers.class);
    private static final String MAX_AGE = "max-age=";

    public Map<String, Collection<String>> asMap() {
        return this.map.asMap();
    }

    public void put(String name, String value) {
        this.map.put((Object)name, (Object)value);
    }

    public void putAll(@NotNull Headers headers) {
        this.map.putAll(headers.map);
    }

    public void putAll(String name, Iterable<String> values) {
        this.map.putAll((Object)name, values);
    }

    public void putAll(String name, Enumeration<String> values) {
        while (values.hasMoreElements()) {
            this.map.put((Object)name, (Object)values.nextElement());
        }
    }

    public void putAll(String name, String[] values) {
        this.map.putAll((Object)name, Arrays.asList(values));
    }

    public void set(String name, String value) {
        this.map.removeAll((Object)name);
        this.put(name, value);
    }

    public Headers withCache(int days) {
        return this.withCache(days, TimeUnit.DAYS);
    }

    public Headers withCache(int duration, TimeUnit unit) {
        this.set("Cache-Control", "public, max-age=" + unit.toSeconds(duration));
        DateTime now = DateTime.current();
        this.setLastModified(now);
        this.setExpires(now.addMilliseconds(unit.toMillis(duration)));
        return this;
    }

    public Seq<MediaType> getAccept() {
        return this.getFirstAsList("Accept").map(Headers::mediaTypeFor);
    }

    public void setAccept(MediaType ... mimeTypes) {
        this.setAccept(Arrays.asList(mimeTypes));
    }

    public void setAccept(Iterable<MediaType> mediaTypes) {
        this.set("Accept", Colls.mkString(mediaTypes, (String)","));
    }

    public void setAcceptLanguage(Locale locale) {
        this.set("Accept-Language", locale.toLanguageTag());
    }

    public Seq<String> getAll(String key) {
        return this.map.get((Object)key);
    }

    public Seq<Method> getAllow() {
        return this.getFirstAsList("Allow").map(Method::valueOf);
    }

    public void setAllow(Seq<Method> methods) {
        this.set("Allow", methods.mkString(","));
    }

    public long getCacheControlMaxAge() {
        Option<String> cache = this.getFirst("Cache-Control");
        if (cache.isEmpty()) {
            return 0L;
        }
        try {
            return (Long)Strings.split((String)((String)cache.get()), (char)',').map(String::trim).getFirst(s -> s != null && s.startsWith(MAX_AGE)).map(t -> Long.parseLong(t.substring(MAX_AGE.length()))).orElse((Object)0L);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public long getContentLength() {
        return (Long)this.getFirst("Content-Length").map(Long::valueOf).orElse((Object)-1L);
    }

    public void setContentLength(long contentLength) {
        this.set("Content-Length", Long.toString(contentLength));
    }

    @Nullable
    public MediaType getContentType() {
        return (MediaType)this.getFirst("Content-Type").map(Headers::mediaTypeFor).getOrNull();
    }

    public void setContentType(MediaType mediaType) {
        this.set("Content-Type", mediaType.toString());
    }

    public void setExpires(@NotNull DateTime time) {
        this.set("Expires", DATE_HEADER_FORMAT.format(time.toDate()));
    }

    public Option<String> getFirst(String key) {
        return this.map.get((Object)key).getFirst();
    }

    public Seq<String> getKeys() {
        return this.map.keys();
    }

    public void setLastModified(@NotNull DateTime time) {
        this.set("Last-Modified", DATE_HEADER_FORMAT.format(time.toDate()));
    }

    @Nullable
    public URI getLocation() {
        return (URI)this.getFirst("Location").map(URI::create).getOrNull();
    }

    public void setLocation(URI location) {
        this.set("Location", location.toASCIIString());
    }

    public String getOrEmpty(String key) {
        return (String)this.getFirst(key).orElse((Object)"");
    }

    @Nullable
    public String getOrigin() {
        return (String)this.getFirst("Origin").getOrNull();
    }

    public void setOrigin(String origin) {
        this.set("Origin", origin);
    }

    private Seq<String> getFirstAsList(String name) {
        Option<String> value = this.getFirst(name);
        if (value.isEmpty()) {
            return Colls.emptyIterable();
        }
        ArrayList result = new ArrayList();
        Collections.addAll(result, ((String)value.get()).split(",\\s*"));
        return Colls.seq(result);
    }

    @Nullable
    private static MediaType mediaTypeFor(String headerValue) {
        try {
            return MediaType.fromString(headerValue);
        }
        catch (InvalidMediaTypeException e) {
            logger.error((Throwable)e);
            return null;
        }
    }
}

