/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.service;

import java.io.IOException;
import java.lang.reflect.Type;
import mulesoft.common.Predefined;
import mulesoft.common.logging.Logger;
import mulesoft.common.media.MediaType;
import mulesoft.common.service.InboundMessage;
import mulesoft.common.service.etl.MessageConverter;
import mulesoft.common.service.etl.StringMessageConverter;
import mulesoft.common.service.exception.MessageConversionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InboundMessageReader<T> {
    @Nullable
    private MediaType defaultContentType;
    @NotNull
    private final Type genericType;
    @NotNull
    private final Class<T> type;
    private static final Logger logger = Logger.getLogger(InboundMessageReader.class);

    public InboundMessageReader(@NotNull Class<T> type) {
        this(type, type);
    }

    public InboundMessageReader(@NotNull Class<T> type, @NotNull Type genericType) {
        this.type = type;
        this.genericType = genericType;
        this.defaultContentType = null;
    }

    public T read(@NotNull InboundMessage message, @NotNull Iterable<MessageConverter<?>> converters) {
        MediaType contentType = this.getContentType(message);
        MessageConverter<T> converter = this.getSuitableConverter(converters, contentType);
        if (converter == null) {
            String msg = "Could not extract inbound message: no suitable converter found for type '" + this.type + "' and content type '" + contentType + "'";
            String body = this.bodyAsString(message);
            logger.error(msg + " with body: " + body);
            throw new MessageConversionException(msg);
        }
        try {
            return converter.read(this.type, this.genericType, contentType, message.getContent());
        }
        catch (IOException e) {
            throw new MessageConversionException(e);
        }
    }

    public void setDefaultContentType(@Nullable MediaType contentType) {
        this.defaultContentType = contentType;
    }

    private String bodyAsString(@NotNull InboundMessage response) {
        try {
            return new StringMessageConverter().read(String.class, (Type)((Object)String.class), this.getContentType(response), response.getContent());
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            return "[cannot read message]";
        }
    }

    private void log(@Nullable MediaType contentType, MessageConverter<?> messageConverter) {
        logger.debug("Reading '" + this.type.getName() + "' as '" + contentType + "' using '" + messageConverter + "'");
    }

    @Nullable
    private MediaType getContentType(@NotNull InboundMessage message) {
        MediaType contentType = message.getHeaders().getContentType();
        if (contentType == null) {
            logger.debug("No Content-Type header found, reading message as " + this.defaultContentType);
        }
        return contentType != null ? contentType : this.defaultContentType;
    }

    @Nullable
    private MessageConverter<T> getSuitableConverter(Iterable<MessageConverter<?>> converters, @Nullable MediaType contentType) {
        for (MessageConverter<T> messageConverter : converters) {
            if (!messageConverter.canRead(this.type, this.genericType, contentType)) continue;
            this.log(contentType, messageConverter);
            return (MessageConverter)Predefined.cast(messageConverter);
        }
        return null;
    }
}

