/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.service;

import java.io.IOException;
import mulesoft.common.Predefined;
import mulesoft.common.logging.Logger;
import mulesoft.common.media.MediaType;
import mulesoft.common.service.OutboundMessage;
import mulesoft.common.service.etl.MessageConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutboundMessageWriter {
    @Nullable
    private MediaType defaultContentType = null;
    private static final Logger logger = Logger.getLogger(OutboundMessageWriter.class);

    public void write(@NotNull OutboundMessage message, @NotNull Iterable<MessageConverter<?>> converters, @NotNull Object payload) throws IOException {
        Class<?> payloadType = payload.getClass();
        MediaType contentType = this.getContentType(message);
        for (MessageConverter<?> messageConverter : converters) {
            if (!messageConverter.canWrite(payloadType, payloadType, contentType)) continue;
            this.log(contentType, messageConverter, payload);
            MessageConverter typedConverter = (MessageConverter)Predefined.cast(messageConverter);
            typedConverter.write(payload, contentType, message.getHeaders());
            typedConverter.write(payload, contentType, message.getContent());
            return;
        }
        String msg = "Could not write message: no suitable MessageConverter found for payload type [" + payloadType.getName() + "]";
        if (contentType != null) {
            msg = msg + " and content type [" + contentType + "]";
        }
        throw new IllegalStateException(msg);
    }

    public void setDefaultContentType(@Nullable MediaType contentType) {
        this.defaultContentType = contentType;
    }

    private void log(@Nullable MediaType contentType, MessageConverter<?> messageConverter, Object payload) {
        if (logger.isLoggable(Logger.Level.DEBUG)) {
            if (contentType != null) {
                logger.debug("Writing [" + payload + "] as \"" + contentType + "\" using [" + messageConverter + "]");
            } else {
                logger.debug("Writing [" + payload + "] using [" + messageConverter + "]");
            }
        }
    }

    @Nullable
    private MediaType getContentType(@NotNull OutboundMessage message) {
        MediaType contentType = message.getHeaders().getContentType();
        if (contentType == null && logger.isLoggable(Logger.Level.DEBUG)) {
            logger.debug("No Content-Type header found, writing message as " + this.defaultContentType);
        }
        return contentType != null ? contentType : this.defaultContentType;
    }
}

