/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.service;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import mulesoft.common.collections.Colls;
import mulesoft.common.collections.MultiMap;
import mulesoft.common.core.Strings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Parameters {
    private Parameters() {
    }

    public static String mapToQueryString(MultiMap<String, String> parameters) {
        return Parameters.mapToQueryString(parameters.asMap());
    }

    public static String mapToQueryString(Map<String, Collection<String>> stringCollectionMap) {
        return Colls.map(stringCollectionMap.entrySet(), Parameters::encodedQueryFromParameters).mkString("&");
    }

    @Nullable
    public static MultiMap<String, String> queryStringToMap(@Nullable String parameters) {
        return parameters == null ? null : Parameters.parametersFromQuery(parameters);
    }

    @NotNull
    private static String encodedQueryFromParameters(Map.Entry<String, Collection<String>> entry) {
        return Colls.map((Iterable)entry.getValue(), value -> Parameters.utf8Encode((String)entry.getKey()) + "=" + Parameters.utf8Encode(value)).mkString("&");
    }

    @NotNull
    private static MultiMap<String, String> parametersFromQuery(String parameters) {
        MultiMap result = MultiMap.createLinkedMultiMap();
        for (String param : Strings.split((String)parameters, (char)'&')) {
            int i = param.indexOf("=");
            if (i == -1) continue;
            result.put((Object)param.substring(0, i), (Object)param.substring(i + 1));
        }
        return result;
    }

    private static String utf8Encode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

