/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.service;

import java.util.EnumSet;
import java.util.Map;
import java.util.TreeMap;

public enum Status {
    CONTINUE(100),
    SWITCHING_PROTOCOLS(101),
    OK(200),
    CREATED(201),
    ACCEPTED(202),
    NON_AUTHORITATIVE_INFORMATION(203),
    NO_CONTENT(204),
    RESET_CONTENT(205),
    PARTIAL_CONTENT(206),
    MULTIPLE_CHOICES(300),
    MOVED_PERMANENTLY(301),
    FOUND(302),
    SEE_OTHER(303),
    NOT_MODIFIED(304),
    USE_PROXY(305),
    TEMPORARY_REDIRECT(307),
    BAD_REQUEST(400),
    UNAUTHORIZED(401),
    PAYMENT_REQUIRED(402),
    FORBIDDEN(403),
    NOT_FOUND(404),
    METHOD_NOT_ALLOWED(405),
    NOT_ACCEPTABLE(406),
    PROXY_AUTHENTICATION_REQUIRED(407),
    REQUEST_TIMEOUT(408),
    CONFLICT(409),
    GONE(410),
    LENGTH_REQUIRED(411),
    PRECONDITION_FAILED(412),
    REQUEST_ENTITY_TOO_LARGE(413),
    REQUEST_URI_TOO_LONG(414),
    UNSUPPORTED_MEDIA_TYPE(415),
    REQUESTED_RANGE_NOT_SATISFIABLE(416),
    EXPECTATION_FAILED(417),
    LOCKED(423),
    TOO_MANY_REQUEST(429),
    INTERNAL_SERVER_ERROR(500),
    NOT_IMPLEMENTED(501),
    BAD_GATEWAY(502),
    SERVICE_UNAVAILABLE(503),
    GATEWAY_TIMEOUT(504),
    HTTP_VERSION_NOT_SUPPORTED(505);

    private final int code;
    private static final Status[] VALUES;
    private static final Map<Integer, Status> codeToStatus;
    private static final EnumSet<Status> informational;
    private static final EnumSet<Status> successful;
    private static final EnumSet<Status> redirection;
    private static final EnumSet<Status> clientError;
    private static final EnumSet<Status> serverError;

    private Status(int code) {
        this.code = code;
    }

    public int code() {
        return this.code;
    }

    public boolean isInformational() {
        return informational.contains((Object)this);
    }

    public boolean isSuccessful() {
        return successful.contains((Object)this);
    }

    public boolean isRedirection() {
        return redirection.contains((Object)this);
    }

    public boolean isClientError() {
        return clientError.contains((Object)this);
    }

    public boolean isError() {
        return this.isClientError() || this.isServerError();
    }

    public boolean isServerError() {
        return serverError.contains((Object)this);
    }

    public static Status fromCode(int code) {
        return codeToStatus.get(code);
    }

    static {
        VALUES = Status.values();
        informational = EnumSet.range(CONTINUE, SWITCHING_PROTOCOLS);
        successful = EnumSet.range(OK, PARTIAL_CONTENT);
        redirection = EnumSet.range(MULTIPLE_CHOICES, TEMPORARY_REDIRECT);
        clientError = EnumSet.range(BAD_REQUEST, TOO_MANY_REQUEST);
        serverError = EnumSet.range(INTERNAL_SERVER_ERROR, HTTP_VERSION_NOT_SUPPORTED);
        codeToStatus = new TreeMap<Integer, Status>();
        for (Status status : VALUES) {
            codeToStatus.put(status.code(), status);
        }
    }
}

