/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.service.cookie;

import mulesoft.common.core.Strings;
import mulesoft.common.service.cookie.Cookie;
import mulesoft.common.service.cookie.Cookies;
import mulesoft.common.service.cookie.MutableCookie;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ClientCookies {
    private ClientCookies() {
    }

    @Nullable
    static Cookie decode(@NotNull String header) {
        String[] bites = header.split("[;]");
        MutableCookie cookie = null;
        for (String bite : bites) {
            String[] crumbs = bite.split("=", 2);
            String name = crumbs.length > 0 ? crumbs[0].trim() : "";
            String value = Strings.unquote((String)(crumbs.length > 1 ? crumbs[1].trim() : ""));
            if (cookie == null) {
                cookie = Cookies.create(name, value);
                continue;
            }
            String key = name.toLowerCase();
            if (key.startsWith("domain")) {
                cookie.withDomain(value);
                continue;
            }
            if (key.startsWith("max-age")) {
                cookie.withMaxAge(Integer.parseInt(value));
                continue;
            }
            if (key.startsWith("path")) {
                cookie.withPath(value);
                continue;
            }
            if (key.startsWith("secure")) {
                cookie.withSecure(true);
                continue;
            }
            if (!key.startsWith("httponly")) continue;
            cookie.withHttpOnly(true);
        }
        return cookie;
    }

    @NotNull
    static String encode(@NotNull Cookie cookie) {
        StringBuilder builder = new StringBuilder();
        builder.append(cookie.getName()).append('=');
        Cookies.appendQuotedIfWhitespace(builder, cookie.getValue());
        return builder.toString();
    }
}

