/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.service.cookie;

import mulesoft.common.collections.Colls;
import mulesoft.common.collections.ImmutableList;
import mulesoft.common.core.Strings;
import mulesoft.common.service.Headers;
import mulesoft.common.service.cookie.ClientCookies;
import mulesoft.common.service.cookie.Cookie;
import mulesoft.common.service.cookie.MutableCookie;
import mulesoft.common.service.cookie.ServerCookies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Cookies {
    private Cookies() {
    }

    @NotNull
    public static MutableCookie create(String name, String value) {
        return new MutableCookieImpl(name, value);
    }

    public static Iterable<Cookie> decodeClientCookies(@NotNull Headers headers) {
        return headers.getAll("Set-Cookie").map(ClientCookies::decode);
    }

    public static void encodeClientCookies(@NotNull Headers headers, @NotNull Iterable<Cookie> cookies) {
        ImmutableList list = Colls.toList(cookies);
        if (!list.isEmpty()) {
            headers.put("Cookie", list.map(ClientCookies::encode).mkString("; "));
        }
    }

    public static void encodeServerCookies(@NotNull Headers headers, @NotNull Iterable<Cookie> cookies) {
        ImmutableList list = Colls.toList(cookies);
        if (!list.isEmpty()) {
            headers.putAll("Set-Cookie", (Iterable<String>)list.map(ServerCookies::encode));
        }
    }

    public static boolean equal(Cookie a, Cookie b) {
        return a == b || b != null && a.getMaxAge() == b.getMaxAge() && a.isHttpOnly() == b.isHttpOnly() && a.isSecure() == b.isSecure() && a.getName().equals(b.getName()) && (a.getDomain() != null ? a.getDomain().equals(b.getDomain()) : b.getDomain() == null && (a.getPath() != null ? a.getPath().equals(b.getPath()) : b.getPath() == null && a.getValue().equals(b.getValue())));
    }

    public static int hash(Cookie cookie) {
        int result = cookie.getName().hashCode();
        result = 31 * result + (cookie.getDomain() != null ? cookie.getDomain().hashCode() : 0);
        result = 31 * result + (int)(cookie.getMaxAge() ^ cookie.getMaxAge() >>> 32);
        result = 31 * result + (cookie.isHttpOnly() ? 1 : 0);
        result = 31 * result + (cookie.getPath() != null ? cookie.getPath().hashCode() : 0);
        result = 31 * result + (cookie.isSecure() ? 1 : 0);
        result = 31 * result + cookie.getValue().hashCode();
        return result;
    }

    public static String toString(@NotNull Cookie cookie) {
        return "{name='" + cookie.getName() + '\'' + ", value='" + cookie.getValue() + '\'' + ", domain='" + cookie.getDomain() + '\'' + ", path='" + cookie.getPath() + '\'' + ", maxAge=" + cookie.getMaxAge() + ", http=" + cookie.isHttpOnly() + ", secure=" + cookie.isSecure() + '}';
    }

    static void appendQuotedIfWhitespace(@NotNull StringBuilder b, @NotNull String value) {
        b.append(Strings.containsWhiteSpace((String)value) ? Strings.quoted((String)value) : value);
    }

    private static class MutableCookieImpl
    implements MutableCookie {
        private String domain = null;
        private boolean http = false;
        private long maxAge = -1L;
        private final String name;
        private String path = null;
        private boolean secure = false;
        private String value;

        private MutableCookieImpl(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Cookie && Cookies.equal(this, (Cookie)o);
        }

        public int hashCode() {
            return Cookies.hash(this);
        }

        public String toString() {
            return Cookies.toString(this);
        }

        @Override
        public MutableCookie withDomain(@Nullable String d) {
            this.domain = d;
            return this;
        }

        @Override
        public MutableCookie withHttpOnly(boolean flag) {
            this.http = flag;
            return this;
        }

        @Override
        public MutableCookie withMaxAge(long seconds) {
            this.maxAge = seconds;
            return this;
        }

        @Override
        public MutableCookie withPath(@Nullable String p) {
            this.path = p;
            return this;
        }

        @Override
        public MutableCookie withSecure(boolean flag) {
            this.secure = flag;
            return this;
        }

        @Override
        public MutableCookie withValue(@NotNull String v) {
            this.value = v;
            return this;
        }

        @Override
        @Nullable
        public String getDomain() {
            return this.domain;
        }

        @Override
        public boolean isSecure() {
            return this.secure;
        }

        @Override
        public long getMaxAge() {
            return this.maxAge;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @Nullable
        public String getPath() {
            return this.path;
        }

        @Override
        @NotNull
        public String getValue() {
            return this.value;
        }

        @Override
        public boolean isHttpOnly() {
            return this.http;
        }
    }
}

