/*
 * Decompiled with CFR 0.152.
 */
package mulesoft.common.service.cookie;

import mulesoft.common.service.cookie.Cookie;
import mulesoft.common.service.cookie.Cookies;
import org.jetbrains.annotations.NotNull;

class ServerCookies {
    private ServerCookies() {
    }

    @NotNull
    static String encode(@NotNull Cookie cookie) {
        StringBuilder builder = new StringBuilder();
        builder.append(cookie.getName()).append('=');
        Cookies.appendQuotedIfWhitespace(builder, cookie.getValue());
        if (cookie.getDomain() != null) {
            builder.append(";Domain=");
            Cookies.appendQuotedIfWhitespace(builder, cookie.getDomain());
        }
        if (cookie.getPath() != null) {
            builder.append(";Path=");
            Cookies.appendQuotedIfWhitespace(builder, cookie.getPath());
        }
        if (cookie.getMaxAge() != -1L) {
            builder.append(";Max-Age=");
            builder.append(cookie.getMaxAge());
        }
        if (cookie.isSecure()) {
            builder.append(";Secure");
        }
        if (cookie.isHttpOnly()) {
            builder.append(";HTTPOnly");
        }
        return builder.toString();
    }
}

